ORCA/M Asm65816 2.1.0

0001 32BA                       title 'Desk Manager--NDA Calls'
0002 32BA              **********************************************************************
0003 32BA              *
0004 32BA              * Desk Manager  
0005 32BA              * for the Apple II GS
0006 32BA              *
0007 32BA              * original CDA code by John Worthinton.
0008 32BA              * original NDA code by Steven Glass
0009 32BA              *
0010 32BA              * Additions and alterations by Steven Glass and
0011 32BA              * Konstantin Othmer
0012 32BA              *
0013 32BA              * 5.x work by Harry Yee and Mensch
0014 32BA              *
0015 32BA              * System 6.0 work by Dave Lyons
0016 32BA              *
0017 32BA              * This file contains
0018 32BA              *
0019 32BA              *	SystemEvent
0020 32BA              *	CheckNDAStuff
0021 32BA              *	CallCDAMenu
0022 32BA              *	InstallNDA
0023 32BA              *	OpenNDA
0024 32BA              *	CloseNDA
0025 32BA              *	CloseNDAByWinPtr
0026 32BA              *	CloseAllNDAs2
0027 32BA              *	DoCloseStuff
0028 32BA              *	SystemTask
0029 32BA              *	SystemClick
0030 32BA              *	SystemEdit
0031 32BA              *	FixAppleMenu2
0032 32BA              *	GetNumNDAs
0033 32BA              *	DeskUtils
0034 32BA              *	FindThisWindow
0035 32BA              *	AreWeTop
0036 32BA              *	SendAction
0037 32BA              *	SendOpen
0038 32BA              *	SendClose
0039 32BA              *	SendInit
0040 32BA              *	StartNDACall
0041 32BA              *	EndNDACall
0042 32BA              *	AddToRunQ
0043 32BA              *	RemoveFromRunQ
0044 32BA              *	ExecuteRunItem
0045 32BA              *	RemoveNDA
0046 32BA              *	GetDeskAccInfo	DAL
0047 32BA              *	CallDeskAcc	DAL
0048 32BA              *	GetDeskGlobal	DAL
0049 32BA              *
0050 32BA              **********************************************************************
0051 32BA
0052 32BA              **********************************************************************
0053 32BA              *                                                                    *
0054 32BA              *                   Copyright (C) 1985-1989                          *
0055 32BA              *                   All Rights Reserved                              *
0056 32BA              *                   Apple Computer, Inc.                             *
0057 32BA              *                                                                    *
0058 32BA              **********************************************************************
0059 32BA
0060 32BA
0061 32BA              **********************************************************************
0062 32BA              *
0063 32BA              * Change History
0064 32BA              *
0065 32BA              * 19 Feb 89         Steven Glass
0066 32BA              *
0067 32BA              * Made this work with resource manager.
0068 32BA              *
0069 32BA              * 15 Mar 89         Steven Glass
0070 32BA              *
0071 32BA              * Added FrontToAX to call front window for other routines.  Saved
0072 32BA              * lots of calls.
0073 32BA              *
0074 32BA              * SystemClick selects window if grow clicked in back window
0075 32BA              * instead of growing.
0076 32BA              *
0077 32BA              * 3/16/89           Mensch
0078 32BA              * Added stilldown call to clickinDrag routine, selecting the window was
0079 32BA              * occuring too slowly, and there was enough time to click somewhere else
0080 32BA              * before draw was being called.
0081 32BA              *
0082 32BA              * 19 Apr 89         Steven Glass
0083 32BA              *
0084 32BA              * Fixed bug in SystemEdit where return code from DA was trashed while 
0085 32BA              * restoring the resource manager's user id.
0086 32BA              *
0087 32BA              * 02 Jun 89         Steven Glass
0088 32BA              *
0089 32BA              * Fixed bugs relating to re-entrancy.  When the desk manager
0090 32BA              * is re-entered the handle is locked and unlocked, leaving the first
0091 32BA              * entry with a dangling pointer.  We now inc a counter and dec a 
0092 32BA              * counter so that the unlock only occurs when the counter gets to zero.
0093 32BA              *
0094 32BA              * 28 Aug 89         Harry Yee
0095 32BA              * Fixed bugs relating to fix made 02 Jun 89. The counter thats inc'ed
0096 32BA              * is done in routine DerefNDAList and dec'ed in UnlockNDAList. This 
0097 32BA              * counter gets imbalanced on occasion because the routines GetNumNDAs,
0098 32BA              * AddtoRunQ, and RemoveFromRunQ call DerefNDAList but not UnlockNDAList.
0099 32BA              * I now make sure both calls are made. BRC #52333. This fixes the 
0100 32BA              * problem for ROM 01 machines but not for ROM 03. Fix must be made in
0101 32BA              * the desk mgr patch file.
0102 32BA              *
0103 32BA              * 15 Feb 90         Harry Yee
0104 32BA              * Fix bug in RemoveNDA. The ptr PtrToThisOne was being used to keep track
0105 32BA              * of where the next NDA was to be moved to. This ptr was never updated 
0106 32BA              * during each iteration of the loop that moved all NDAs up one position.
0107 32BA              *
0108 32BA              * 17-Sep-90         Dave Lyons
0109 32BA              * Removed dependency on all.macros.
0110 32BA              *
0111 32BA              * 20..25-Nov-90     Dave Lyons
0112 32BA              *
0113 32BA              * Changed FixAppleMenu (procedure now named FixAppleMenu2) to insert
0114 32BA              * the NDA items in alphabetical order if bit 0 of battery RAM location
0115 32BA              * $5F is set.
0116 32BA              * Put back all.macros.
0117 32BA              *
0118 32BA              * 27-Nov-90         Dave Lyons
0119 32BA              *
0120 32BA              * Made sorting ignore leading blanks (GetNamePointer skips past them).
0121 32BA              *
0122 32BA              * 30-Nov-90         Dave Lyons
0123 32BA              *
0124 32BA              * Changed CompareTwo to return CLC for equal names, so it doesn't hang
0125 32BA              * if there are two identically-named NDAs.
0126 32BA              *
0127 32BA              * 3-Jan-90          Dave Lyons
0128 32BA              *
0129 32BA              * Changed SystemEvent so that Apple-w or Apple-W with a System
0130 32BA              * window in front calls CloseNDAByWinPtr and returns TRUE, instead
0131 32BA              * of letting the DA or the application handle the Apple-W.
0132 32BA              *
0133 32BA              * 19-Feb-91         Dave Lyons
0134 32BA              *
0135 32BA              * Changed FindThisWindow to examine the Aux Wind Info & fetch an
0136 32BA              * NDA Structure pointer from there.  This works pretty dang well!
0137 32BA              * Didn't have to modify the other things that call it.
0138 32BA              *
0139 32BA              * New call GetDeskGlobal.  For selector 0, returns the pointer of
0140 32BA              * the last window the Desk Manager examined.  Other selectors return
0141 32BA              * error $0520.
0142 32BA              *
0143 32BA              * 11-Mar-91        Dave Lyons
0144 32BA              *
0145 32BA              * Implementing GetDeskAccInfo and CallDeskAcc.
0146 32BA              *
0147 32BA              * 17-Apr-91         Dave Lyons
0148 32BA              *
0149 32BA              * Removed GetWKind call from SystemEvent; now I look directly at the
0150 32BA              * window record instead, since GetWKind was changing some Window Mgr
0151 32BA              * direct page stuff.  This was very bad if SystemEvent got called
0152 32BA              * from within a window manager call, and it was making DragWindow
0153 32BA              * always drag the front window!
0154 32BA              *
0155 32BA              * 21-Apr-91         Dave Lyons
0156 32BA              *
0157 32BA              * Changed SystemTask to return with no error if GS/OS is busy.
0158 32BA              * Changed SystemClick to honor the qContent bit of a system window
0159 32BA              * (if set, click is passed to the NDA after it is selected).
0160 32BA              *
0161 32BA              * 2-May-91          Dave Lyons
0162 32BA              *
0163 32BA              * After CloseAllNDAs closes true NDAs, now it goes through open
0164 32BA              * windows closing any remaining system windows (by calling
0165 32BA              * CloseNDAByWinPtr).
0166 32BA              *
0167 32BA              * 10-May-91         Dave Lyons
0168 32BA              *
0169 32BA              * Fixed CloseAllNDAs logic so that getting an error on CloseNDAByWinPtr
0170 32BA              * on a non-NDA system window does not cause an infinite loop!  This
0171 32BA              * was causing a hang with Video Keyboard open.
0172 32BA              *
0173 32BA              * 4-Jul-91          Dave Lyons
0174 32BA              *
0175 32BA              * Modified SystemClick so the first thing is does is offer to let the
0176 32BA              * NDA handle the event completely, by calling CallDeskAcc with action
0177 32BA              * code 10.
0178 32BA              *
0179 32BA              * 24-Jul-91         Dave Lyons
0180 32BA              *
0181 32BA              * FixAppleMenu calls SendRequest($051E=systemSaysFixedAppleMenu) after
0182 32BA              * it's done.
0183 32BA              *
0184 32BA              * 9-Aug-91          Dave Lyons
0185 32BA              *
0186 32BA              * OpenNDA now preserves the current port and sets the "standard" QD
0187 32BA              * port.
0188 32BA              *
0189 32BA              * 16-Sep-91         Dave Lyons
0190 32BA              *
0191 32BA              * FixAppleMenu now checks RealDeskStatus to see if we're started up;
0192 32BA              * if not, it tries DeskStartUp.  If we're *still* not started up, then
0193 32BA              * no NDA items are added to the Apple menu.
0194 32BA              *
0195 32BA              * 17-Sep-91         Dave Lyons
0196 32BA              *
0197 32BA              * Small changes to support moving calls into Tool.Setup.
0198 32BA              *
0199 32BA              * 11-Oct-91         Dave Lyons
0200 32BA              *
0201 32BA              * Added a WindStatus check in the Command-W handling.
0202 32BA              *
0203 32BA              * 9-Nov-91          Dave Lyons
0204 32BA              *
0205 32BA              * Changed default minimum-size for a system window (when the system
0206 32BA              * calls GrowWindow) to width=78, height=34.
0207 32BA              *
0208 32BA              * 4-Dec-91          Dave Lyons
0209 32BA              *
0210 32BA              * When SystemClick handles a click on a non-front system window that has
0211 32BA              * the fQContent bit set, after the window comes to the front SystemClick
0212 32BA              * calls FindWindow to see what part of the window the click is really in.
0213 32BA              * (To see the result, try clicking in the close box of a not-in-front system
0214 32BA              * window with the fQContent bit set, like Control Panels 2.0 or an individual
0215 32BA              * control panel window.  Now it closes.  Before, the event got passed to the
0216 32BA              * system window's Action routine, which was not prepared to handle it.
0217 32BA              * Typically it just called TaskMasterDA, which would track the close box, but
0218 32BA              * nobody would close the window.)
0219 32BA              *
0220 32BA              * 12-Dec-91         Dave Lyons
0221 32BA              *
0222 32BA              * When SystemEvent sees a Command-W and a system window is in front, it
0223 32BA              * now uses CallDeskAcc to pass action $000B, giving the NDA a chance to
0224 32BA              * handle the key itself before forcibly calling CloseNDAbyWinPtr.
0225 32BA              *
0226 32BA              **********************************************************************
0227 32BA              *
0228 32BA              * 26-Jun-92         Dave Lyons for 6.0.1
0229 32BA              *
0230 32BA              * Changed SendAction to allow stack-based action rouines.  If you set
0231 32BA              * bit 31 of the action routine pointer, we push the stuff on the stack
0232 32BA              * so you can write in Pascal or whatever.
0233 32BA              *
0234 32BA              *   function MyActionProc(code: integer; data:long): integer;
0235 32BA              *
0236 32BA              * 2-Jul-92          Dave Lyons
0237 32BA              *
0238 32BA              * When you OpenNDA sees the NDA is already open (has a window pointer),
0239 32BA              * it tries sending a CallDeskAcc(reOpenAction=$000C).  If the DA takes
0240 32BA              * that and puts a $0001 in the word pointed to by XY, OpenNDA takes no
0241 32BA              * further action (otherwise it calls SelectWindow).
0242 32BA              *
0243 32BA              **********************************************************************
0244 32BA
0245 32BA                       include 'all.macros' 
0246 32BA
0247 32BA                       include '::sys.equs.asm' 
0248 32BA                       include 'Desk.Equates.asm' 
0249 32BA                       include 'e16.memory' 
0250 32BA
0251 32BA
0252 32BA                       title 'Desk Manager--desk/DESK.SRC'
0253 32BA              *****************************************************************
0254 32BA              *
0255 32BA              * System Event
0256 32BA              *
0257 32BA              *         result  :  boolean     (word)
0258 32BA              *         mods    :  modifiers   (long)
0259 32BA              *         where   :  point       (long)
0260 32BA              *         when    :  long
0261 32BA              *         message :  long
0262 32BA              *         what   :   event code  (word)
0263 32BA              *   SP->
0264 32BA              *
0265 32BA              * Apologies to those who follow but we had to perform a little
0266 32BA              * kludge here.  The ChoseCDA routine in ROM does a silly thing
0267 32BA              * to decide how to get input.  It loads the address of an
0268 32BA              * input routine decrements it once and does an RTS.  This
0269 32BA              * address unfortunatley is setup by SystemEvent.  With this
0270 32BA              * patch, SystemEvent is not in the same bank and does not
0271 32BA              * know the addresses of the input routines.
0272 32BA              *
0273 32BA              * So what do I do?  Well the input routine not to use has its
0274 32BA              * address in the variable KeyINput.  It is easy to save and
0275 32BA              * restore it without caring what it is.  The routine that
0276 32BA              * we need to use is $D bytes after the routine not to use.
0277 32BA              *
0278 32BA              * Without knowing where it is I can guarentee that the routine
0279 32BA              * will not change size or relative position in future ROMs.
0280 32BA              *
0281 32BA              * Thus I calculate the address of the routine to use by adding
0282 32BA              * $D to the address of the routine not to use.
0283 32BA              *
0284 32BA              * This routine also has to prevent multiple entries into the
0285 32BA              * CDA menu.  I do this by checking a flag on entry.  If this
0286 32BA              * flag is non zero we skip the work.  If the flag is zero,
0287 32BA              * we set the flag to non zero and bring up the menu.  When
0288 32BA              * we return from the menu, we set the flag back to zero.
0289 32BA              *
0290 32BA              * Modification History
0291 32BA              *
0292 32BA              * 01 Oct 87    Steven Glass
0293 32BA              *
0294 32BA              * Routine rewritten to run in ROM.
0295 32BA              *
0296 32BA              *
0297 32BA              * 31 Mar 88         Steven Glass
0298 32BA              *
0299 32BA              * This code now checks to see if the CDA menu is active before
0300 32BA              * trying to pass events to NDAs.
0301 32BA              *
0302 32BA              * 12/5/89           Mensch
0303 32BA              *
0304 32BA              * Added code so that system event does not claim certain keyboard events. This allows
0305 32BA              * DA's to accept certain menu key equivalents.
0306 32BA              *
0307 32BA              ****************************************************************
0308 32BA                       EXPORT SystemEvent 
0309 32BA              SystemEvent PROC EXPORT 
0310 32BA
0311 32BA
0312 32BA                       DefineStack 
0313 32BA              OrigD    word 
0314 32BA              DAPtr    long 
0315 32BA              DAHandle long 
0316 32BA              procstat byte 
0317 32BA              ret1     block 3
0318 32BA              ret2     block 3
0319 32BA              swhat    word 
0320 32BA              smessage long 
0321 32BA              swhen    long 
0322 32BA              swhere   long 
0323 32BA              smods    word 
0324 32BA              result   word 
0325 32BA
0326 32BA
0327 32BA              SizeOfMonKeyIn equ   $D
0328 32BA
0329 32BA 08                    php                            ; turn off interrupts because
0330 32BB 78                    sei                            ; dahandler expects them off
0331 32BC
0332 32BC 5A                    phy                            ; save handle to data structure
0333 32BD 48                    pha                            ; on stack (value from WAP table)
0334 32BE 5A                    phy                            ; save again to make room for
0335 32BF 48                    pha                            ; pointer.
0336 32C0 0B                    phd                            ; save direct page
0337 32C1 3B                    tsc                            ; get stack pointer
0338 32C2 5B                    tcd                            ; make it direct
0339 32C3
0340 32C3 64 22                 stz   Result                   ; assume that we will not handle this event
0341 32C5
0342 32C5 A5 12                 lda   swhat                    ; get the event type
0343 32C7 C9 0A 00              cmp   #$000A                   ; is it a DA event
0344 32CA F0 0D                 beq   ItsNDAEvent
0345 32CC
0346 32CC              ;-------------------------------------------------
0347 32CC              ;
0348 32CC              ; Look at the NotAgain flag.  If it is set,
0349 32CC              ; we cannot send events to an NDA.
0350 32CC              ;
0351 32CC 20 56 38              jsr   LocalDeref
0352 32CF
0353 32CF A0 04 00              ldy   #o_NotAgain
0354 32D2 B7 03                 lda   [DAPtr],y
0355 32D4 D0 76                 bne   CannotGoOn
0356 32D6
0357 32D6 82 89 00              brl   CheckNDAStuff            ; No, move on.
0358 32D9
0359 32D9              ItsNDAEvent  
0360 32D9              ;-------------------------------------------------
0361 32D9              ;
0362 32D9              ; It is a DA event.  We will have to try to call
0363 32D9              ; the CDA menu but...
0364 32D9              ;
0365 32D9              ;
0366 32D9              ; Calling SaveScrn clobbers the important variable
0367 32D9              ; NumInts.  So I save NumInts here and restore it
0368 32D9              ; below.
0369 32D9              ;
0370 32D9 E2 30                 sep   #$30
0371 32DB AF 67 1D E0           lda   >NumInts                 ; get num ints and
0372 32DF 48                    pha   
0373 32E0 C2 30                 rep   #$30
0374 32E2
0375 32E2              ;-------------------------------------------------
0376 32E2              ;
0377 32E2              ; Look at the NotAgain flag.  If it is set,
0378 32E2              ; we cannot do this again.
0379 32E2              ;
0380 32E2 20 56 38              jsr   LocalDeref
0381 32E5
0382 32E5 A0 04 00              ldy   #o_NotAgain
0383 32E8 B7 03                 lda   [DAPtr],y
0384 32EA D0 52                 bne   SkipThisOne
0385 32EC
0386 32EC              ;-------------------------------------------------
0387 32EC              ;
0388 32EC              ; Set the KeyInput field so that right routine
0389 32EC              ; is called.  (Save orig KeyInput on stack.)
0390 32EC              ;
0391 32EC AF 8A 1D E0           lda   >keyinput
0392 32F0 48                    pha   
0393 32F1 18                    clc   
0394 32F2 69 0D 00              adc   #SizeofMonKeyIn
0395 32F5 8F 8A 1D E0           sta   >keyinput
0396 32F9
0397 32F9              ;-------------------------------------------------
0398 32F9              ;
0399 32F9              ; Zero the Active flag so that we do not send
0400 32F9              ; keystrokes to NDA's on screen that cannot be
0401 32F9              ; seen by user.  (Save for later restoration.)
0402 32F9              ;
0403 32F9 A0 02 00              ldy   #o_ActiveFlag
0404 32FC B7 03                 lda   [DAPtr],y
0405 32FE 48                    pha   
0406 32FF A9 00 00              lda   #0
0407 3302 97 03                 sta   [DAPtr],y
0408 3304
0409 3304              ;-------------------------------------------------
0410 3304              ;
0411 3304              ; Set notagain flag to prevent multiple entries
0412 3304              ; into CDA menu.
0413 3304              ;
0414 3304 A0 04 00              ldy   #o_NotAgain
0415 3307 A9 00 80              lda   #$8000
0416 330A 97 03                 sta   [DAPtr],y
0417 330C
0418 330C              ;-------------------------------------------------
0419 330C              ;
0420 330C              ; Save current shadow register and set it for
0421 330C              ; use by CDA menu.
0422 330C              ;
0423 330C E2 30                 sep   #$30
0424 330E                       longa off
0425 330E                       longi off
0426 330E AF 35 C0 00           lda   >Shadow
0427 3312 48                    pha   
0428 3313 29 FE                 and   #$FE                     ; force text shawdow on
0429 3315 8F 35 C0 00           sta   >Shadow
0430 3319 C2 30                 rep   #$30
0431 331B                       longa on
0432 331B                       longi on
0433 331B
0434 331B              ;-------------------------------------------------
0435 331B              ;
0436 331B              ; Display the CDA menu and run any CDAs.
0437 331B              ;
0438 331B
0439 331B 22 F7 39 02           jsl   CallCDAMenu
0440 331F
0441 331F              ;-------------------------------------------------
0442 331F              ;
0443 331F              ; Restore the shadow register
0444 331F              ;
0445 331F E2 30                 sep   #$30
0446 3321                       longa off
0447 3321                       longi off
0448 3321 68                    pla   
0449 3322 8F 35 C0 00           sta   >Shadow
0450 3326 C2 30                 rep   #$30
0451 3328                       longa on
0452 3328                       longi on
0453 3328
0454 3328
0455 3328              ;-------------------------------------------------
0456 3328              ;
0457 3328              ; Restore pointer to global data and restore
0458 3328              ; the ActiveFlag.  Then clear the NotAgain flag.
0459 3328              ;
0460 3328 20 56 38              jsr   LocalDeref
0461 332B
0462 332B A0 02 00              ldy   #o_ActiveFlag
0463 332E 68                    pla   
0464 332F 97 03                 sta   [DAPtr],y
0465 3331
0466 3331 A0 04 00              ldy   #o_NotAgain
0467 3334 A9 00 00              lda   #0
0468 3337 97 03                 sta   [DAPtr],y
0469 3339
0470 3339              ;-------------------------------------------------
0471 3339              ;
0472 3339              ; Restore original value of KeyInput (from
0473 3339              ; stack).
0474 3339              ;
0475 3339 68                    pla   
0476 333A 8F 8A 1D E0           sta   >keyinput
0477 333E
0478 333E
0479 333E              SkipThisOne                             ;
0480 333E A9 01 00              lda   #$01                     ; nil means I handled the event
0481 3341 85 22                 sta   result
0482 3343
0483 3343
0484 3343              ;-----------------------------------------------------
0485 3343              ;
0486 3343              ; Restore the NumInts variable from above
0487 3343              ;
0488 3343 E2 30                 sep   #$30
0489 3345 68                    pla   
0490 3346 8F 67 1D E0           sta   >NumInts
0491 334A C2 30                 rep   #$30
0492 334C
0493 334C
0494 334C
0495 334C              CannotGoOn  
0496 334C 2B                    pld                            ; restore the direct page register
0497 334D 68                    pla                            ; pull off the 8 bytes used
0498 334E 68                    pla                            ; for DAHandle and DAPtr
0499 334F 68                    pla   
0500 3350 68                    pla   
0501 3351
0502 3351 28                    plp                            ; restore interrupt status
0503 3352
0504 3352 5C BD 1D 02           jml   oEndCall16
0505 3356
0506 3356
0507 3356
0508 3356 A7 07        LocalDeref lda   [DAHandle]
0509 3358 85 03                 sta   DAPtr
0510 335A A0 02 00              ldy   #2
0511 335D B7 07                 lda   [DAHandle],y
0512 335F 85 05                 sta   DAPtr+2
0513 3361 60                    rts   
0514 3362
0515 3362
0516 3362                       ENDP 
0517 3362
0518 3362
0519 3362
0520 3362              ****************************************************************
0521 3362              *
0522 3362              * CheckNDAStuff
0523 3362              *
0524 3362              * We look at the event type.  For certain events I pass them
0525 3362              * to the Active DA.  For others, I do not.
0526 3362              *
0527 3362              ****************************************************************
0528 3362                       EXPORT CheckNDAStuff 
0529 3362              CheckNDAStuff PROC 
0530 3362
0531 3362 2B                    pld                            ; restore direct page
0532 3363 68                    pla                            ; get WAP values back in A & Y
0533 3364 7A                    ply   
0534 3365 68                    pla   
0535 3366 7A                    ply   
0536 3367 28                    plp                            ; restore interrupt state
0537 3368
0538 3368 5A                    phy   
0539 3369 48                    pha   
0540 336A 5A                    phy   
0541 336B 48                    pha   
0542 336C 0B                    phd   
0543 336D 3B                    tsc   
0544 336E 5B                    tcd   
0545 336F
0546 336F
0547 336F              ;-------------------------------------------------
0548 336F              ;
0549 336F              ; Direct page equates until StartNDACall is made.
0550 336F              ;
0551 336F
0552 336F                       DefineStack 
0553 336F              OrigD    word 
0554 336F              DAPtr    long 
0555 336F              DAHandle long 
0556 336F              sret1    block 3 
0557 336F              sret2    block 3 
0558 336F              swhat    word 
0559 336F              smessage long 
0560 336F              swhen    long 
0561 336F              swhere   long 
0562 336F              smods    word 
0563 336F              sresult  word 
0564 336F
0565 336F              *** added 3-Jan-91 DAL--Apple-W handled by the system
0566 336F A5 11                 lda   <sWhat
0567 3371 C9 05 00              cmp   #$0005                   ; is it auto key down?
0568 3374 F0 05                 beq   @isKey
0569 3376 C9 03 00              cmp   #$0003                   ; is it a key down?
0570 3379 D0 14                 bne   @toDoSysEvent
0571 337B A5 1F        @isKey   lda   <sMods
0572 337D 29 00 01              and   #$0100                   ; see if the apple key is down...
0573 3380 F0 7F                 beq   @DoSysEvent
0574 3382
0575 3382 A5 13                 lda   <sMessage
0576 3384 29 FF 00              and   #$00ff
0577 3387 C9 77 00              cmp   #'w'
0578 338A F0 05                 beq   @DoCloseNDA
0579 338C C9 57 00              cmp   #'W'
0580 338F D0 70        @toDoSysEvent bne   @DoSysEvent
0581 3391
0582 3391              @DoCloseNDA  
0583 3391
0584 3391              *** added 11-Oct-91 DAL -- if Window Manager not here, leave
0585 3391 F4 00 00              pea   0
0586 3394 A2 0E 06 22           _WindStatus 
0587 339B 68                    pla   
0588 339C F0 63                 beq   @DoSysEvent
0589 339E              *** end 11-Oct-91
0590 339E
0591 339E 48                    pha   
0592 339F 48                    pha   
0593 33A0 A2 0E 15 22           _FrontWindow 
0594 33A7 7A                    ply   
0595 33A8 68                    pla   
0596 33A9 D0 05                 bne   @aWindow
0597 33AB BB                    tyx   
0598 33AC D0 02                 bne   @aWindow
0599 33AE 80 51                 bra   @DoSysEvent
0600 33B0
0601 33B0 48           @aWindow pha   
0602 33B1 48                    pha   
0603 33B2 5A                    phy   
0604 33B3 A2 0E 4C 22           _GetSysWFlag 
0605 33BA 68                    pla   
0606 33BB 10 44                 bpl   @DoSysEvent
0607 33BD
0608 33BD              *** added 12-Dec-91 DAL -- give smart NDAs a chance to handle the fascist Command-W
0609 33BD A9 00 00              lda   #0
0610 33C0 8F FF 38 02           sta   >@sysEventBlock
0611 33C4
0612 33C4 F4 00 00              pea   0                        ;space for CallDeskAcc result
0613 33C7 F4 01 00              pea   $0001                    ;call NDA Action routine by window pointer
0614 33CA 48                    pha   
0615 33CB 48                    pha                            ;space for window pointer
0616 33CC A2 0E 15 22           _FrontWindow 
0617 33D3 F4 0B 00              pea   $000B                    ;action code = handle Command-W
0618 33D6 F4 02 00              pea   @sysEventBlock>>16
0619 33D9 F4 FF 38              pea   @sysEventBlock
0620 33DC A2 05 24 22           _CallDeskAcc 
0621 33E3 FA                    plx                            ;discard
0622 33E4 AF FF 38 02           lda   >@sysEventBlock          ;nonzero = NDA handled it
0623 33E8 D0 10                 bne   @exitTrue
0624 33EA              *** end 12-Dec-91
0625 33EA
0626 33EA 48                    pha   
0627 33EB 48                    pha   
0628 33EC A2 0E 15 22           _FrontWindow 
0629 33F3 A2 05 1C 22           _CloseNDAByWinPtr 
0630 33FA
0631 33FA A9 FF FF     @exitTrue lda   #$ffff                  ;result = TRUE
0632 33FD 80 2A                 bra   StoreResult
0633 33FF
0634 33FF 00 00        @sysEventBlock DC W:0                   ;12-Dec-91 DAL
0635 3401
0636 3401              @DoSysEvent  
0637 3401              *** end of 3-Jan-91 DAL addition
0638 3401
0639 3401 A5 11                 lda   swhat
0640 3403 0A                    asl   a                        ; double the event type
0641 3404 AA                    tax                            ; and put in x for later
0642 3405
0643 3405 A7 07                 lda   [DAHandle]
0644 3407 85 03                 sta   DAPtr
0645 3409 A0 02 00              ldy   #2
0646 340C B7 07                 lda   [DAHandle],y
0647 340E 85 05                 sta   DAPtr+2
0648 3410 A0 02 00              ldy   #o_ActiveFlag
0649 3413 B7 03                 lda   [DAPtr],y
0650 3415 D0 05                 bne   WeAreActive
0651 3417
0652 3417 A9 00 00              lda   #0
0653 341A 80 0D                 bra   NeverMind
0654 341C
0655 341C E0 12 00     WeAreActive cpx   #18
0656 341F 90 05                 bcc   ValidEvent
0657 3421 A9 00 00              lda   #0
0658 3424 80 03                 bra   NeverMind
0659 3426
0660 3426 FC 34 39     ValidEvent jsr   (EventTable,x)
0661 3429
0662 3429              NeverMind  
0663 3429 85 21        StoreResult sta   sResult
0664 342B
0665 342B 2B                    pld                            ; clean up the stack
0666 342C 68                    pla   
0667 342D 68                    pla   
0668 342E 68                    pla   
0669 342F 68                    pla   
0670 3430 5C BD 1D 02           jml   oEndCall16
0671 3434
0672 3434
0673 3434 54 39        EventTable DC W:Ignore                  ; 0  null events
0674 3436 54 39                 DC W:Ignore                    ; 1  mouse down
0675 3438 78 39                 DC W:DoIfWants                 ; 2  mouse upt
0676 343A 58 39                 DC W:DoIfWantsKey              ; 3  key down
0677 343C 78 39                 DC W:DoIfWants                 ; 4  undefined
0678 343E 78 39                 DC W:DoIfWants                 ; 5  auto key down
0679 3440 C4 39                 DC W:DoUpdate                  ; 6  update
0680 3442 54 39                 DC W:Ignore                    ; 7  undefined
0681 3444 C4 39                 DC W:DoActivate                ; 8  activate
0682 3446 54 39                 DC W:Ignore                    ; 9  switch event
0683 3448 54 39                 DC W:Ignore                    ; 10 desk acc
0684 344A 54 39                 DC W:Ignore                    ; 11 device driver
0685 344C 54 39                 DC W:Ignore                    ; 12 Ap
0686 344E 54 39                 DC W:Ignore                    ; 13
0687 3450 54 39                 DC W:Ignore                    ; 14
0688 3452 54 39                 DC W:Ignore                    ; 15
0689 3454
0690 3454
0691 3454              ;-------------------------------------------------
0692 3454              ;
0693 3454              ; Equates for direct page after the startNDACall
0694 3454              ; is made.
0695 3454              ; 
0696 3454                       DSect OrigDirect+2 
0697 3454              rtsadr   word 
0698 3454              xOrigD   word 
0699 3454              xDAPtr   long 
0700 3454              xDAHandle long 
0701 3454              xret1    block 3
0702 3454              xret2    block 3
0703 3454              Dwhat    word 
0704 3454              Dmessage long 
0705 3454              Dwhen    long 
0706 3454              Dwhere   long 
0707 3454              Dmods    word 
0708 3454              Dresult  word 
0709 3454
0710 3454
0711 3454 A9 00 00     Ignore   lda   #0
0712 3457 60                    rts   
0713 3458
0714 3458              DoIfWantsKey  
0715 3458              ; This routine tests the event to see if its a keydown that might have menu implications
0716 3458              ; If it does this routine will deny that the event belongs to that NDA
0717 3458              ; This will allow NDA's to handle the cut/copy/paste menu items properly
0718 3458 A5 07                 lda   DAHandle
0719 345A A4 09                 ldy   DAHandle+2
0720 345C
0721 345C 20 BF 3B              jsr   StartNDACall
0722 345F A0 04 00              ldy   #4
0723 3462 B7 15                 lda   [NDAListHandle],y
0724 3464 10 03                 bpl   @1
0725 3466 82 37 00              brl   reallyNo
0726 3469              @1        
0727 3469 20 37 3A              jsr   DerefNDAList
0728 346C
0729 346C 20 13 3B              jsr   AreWeTop
0730 346F 90 2C                 bcc   No
0731 3471 20 A7 39              jsr   TestMenuKey
0732 3474 90 18                 bcc   DIW0010
0733 3476 80 25                 bra   no                       ; if carry set don't handle it! 
0734 3478
0735 3478 A5 07        DoIfWants lda   DAHandle
0736 347A A4 09                 ldy   DAHandle+2
0737 347C
0738 347C 20 BF 3B              jsr   StartNDACall
0739 347F A0 04 00              ldy   #4
0740 3482 B7 15                 lda   [NDAListHandle],y
0741 3484 30 1A                 bmi   reallyNo
0742 3486 20 37 3A              jsr   DerefNDAList
0743 3489
0744 3489 20 13 3B              jsr   AreWeTop
0745 348C 90 0F                 bcc   No
0746 348E              DIW0010   
0747 348E A5 2D                 lda   Dwhat
0748 3490 0A                    asl   a
0749 3491 AA                    tax   
0750 3492 BF B0 39 02           lda   >MaskTable,x
0751 3496 A0 14 00              ldy   #o_EventMask
0752 3499 37 09                 and   [PtrToThisOne],y
0753 349B D0 3A                 bne   SendItOn
0754 349D
0755 349D
0756 349D 20 55 3A     No       jsr   UnlockNDAList
0757 34A0 20 D3 3B     ReallyNo jsr   EndNDACall
0758 34A3
0759 34A3 A9 00 00              lda   #0
0760 34A6 60                    rts   
0761 34A7
0762 34A7              ;----------------------------------------------------
0763 34A7              ; This routine tests the keyboard event for menu keyness...
0764 34A7              ;
0765 34A7              TestMenuKey  
0766 34A7 A5 3B                 lda   Dmods
0767 34A9 29 00 01              and   #$0100                   ; see if the apple key is down....
0768 34AC              ;	bne @Keeptrying
0769 34AC 18                    clc                            ; say not menu key...
0770 34AD 60                    rts   
0771 34AE
0772 34AE              @KeepTrying  
0773 34AE              ; for this release , no command keys for DA's
0774 34AE 38                    sec   
0775 34AF 60                    rts   
0776 34B0
0777 34B0              ;----------------------------------------------------
0778 34B0              ;
0779 34B0              ; events greater than 9 are not passed on.
0780 34B0              ;
0781 34B0 01 00        MaskTable DC W:%0000000000000001        ; 0
0782 34B2 02 00                 DC W:%0000000000000010         ; 1
0783 34B4 04 00                 DC W:%0000000000000100         ; 2
0784 34B6 08 00                 DC W:%0000000000001000         ; 3
0785 34B8 10 00                 DC W:%0000000000010000         ; 4
0786 34BA 20 00                 DC W:%0000000000100000         ; 5
0787 34BC 40 00                 DC W:%0000000001000000         ; 6
0788 34BE 80 00                 DC W:%0000000010000000         ; 7
0789 34C0 00 01                 DC W:%0000000100000000         ; 8
0790 34C2 00 02                 DC W:%0000001000000000         ; 9
0791 34C4
0792 34C4              DoActivate                              ; 
0793 34C4              DoUpdate                                ; 
0794 34C4 A5 07                 lda   DAHandle                 ; set a and y registers before
0795 34C6 A4 09                 ldy   DAHandle+2               ; calling StartNDACall
0796 34C8 20 BF 3B              jsr   StartNDACall
0797 34CB 20 37 3A              jsr   DerefNDAList
0798 34CE
0799 34CE A5 2F                 lda   DMessage
0800 34D0 A6 31                 ldx   DMessage+2
0801 34D2 20 77 3A              jsr   FindThisWindow
0802 34D5 90 C6                 bcc   No
0803 34D7
0804 34D7
0805 34D7 20 21 3B     SendItOn jsr   SetResID
0806 34DA
0807 34DA 7B                    tdc   
0808 34DB 18                    clc   
0809 34DC 69 2D 00              adc   #DWhat
0810 34DF AA                    tax   
0811 34E0 A0 00 00              ldy   #0
0812 34E3 A9 01 00              lda   #DAEventCode
0813 34E6 22 90 3B 02           jsl   SendAction
0814 34EA
0815 34EA 20 4C 3B              jsr   RepResID
0816 34ED
0817 34ED
0818 34ED 20 55 3A              jsr   UnlockNDAList
0819 34F0 20 D3 3B              jsr   EndNDACall
0820 34F3
0821 34F3 A9 00 80              lda   #$8000
0822 34F6 60                    rts   
0823 34F7
0824 34F7
0825 34F7                       ENDP 
0826 34F7
0827 34F7
0828 34F7              ****************************************************************
0829 34F7              *
0830 34F7              * CallCDAMenu
0831 34F7              *
0832 34F7              * This routine is almost identical to the daHandle routine
0833 34F7              * in rom except that we know that we did not get here from
0834 34F7              * an interrupt so interrupt processing code was removed.
0835 34F7              *
0836 34F7              * Also, since this is called through system event, we know
0837 34F7              * that there is no need for scheduling.
0838 34F7              *
0839 34F7              * This routine is called in full native mode (the routine
0840 34F7              * in rom was called in 8 bit mode).
0841 34F7              *
0842 34F7              * There is no information returned by this routine.
0843 34F7              *
0844 34F7              * Change History
0845 34F7              *
0846 34F7              * 01 Oct 87             Steven Glass
0847 34F7              *
0848 34F7              * This routine used in-line storage to preserve the data
0849 34F7              * bank.  It now uses the stack.
0850 34F7              *
0851 34F7              ****************************************************************
0852 34F7              CallCDAMenu PROC EXPORT 
0853 34F7
0854 34F7 8B                    phb                            ; save dbr on stack before anything happens
0855 34F8
0856 34F8 3B                    tsc                            ; save stack for integer basic
0857 34F9 8F 9C 1D E0           sta   >stacksv
0858 34FD
0859 34FD 8B                    phb                            ; stack is saved as $E0/0300
0860 34FE A2 00 01              ldx   #$0100
0861 3501 A0 00 03              ldy   #$0300
0862 3504 A9 FF 00              lda   #$FF
0863 3507 54 E0 00              mvn   $000000,$E00000
0864 350A
0865 350A AB                    plb   
0866 350B
0867 350B A9 FB 01              lda   #$1FB                    ; make sure there's room on stack
0868 350E 1B                    tcs   
0869 350F
0870 350F A2 05 0B 22           _saveall                       ; save everything
0871 3516 A2 05 11 22           _choosecda                     ; display the list of da's
0872 351D A2 05 0C 22           _restall                       ; unsave everything
0873 3524
0874 3524              ;               phb		 	; restore stack (but save b)
0875 3524              ;               phb
0876 3524              ;               pla
0877 3524              ;               sta	     >LocalBRegSave
0878 3524
0879 3524 A2 00 03              ldx   #$0300
0880 3527 A0 00 01              ldy   #$0100
0881 352A A9 FF 00              lda   #$FF
0882 352D 54 00 E0              mvn   $E00000,$000000
0883 3530
0884 3530 AF 9C 1D E0           lda   >stacksv
0885 3534 1B                    tcs   
0886 3535
0887 3535              ;               lda	     >LocalBRegSave
0888 3535              ;               pha
0889 3535              ;               plb
0890 3535              ;               plb
0891 3535
0892 3535 AB                    plb                            ; restore dbr saved first thing.
0893 3536
0894 3536 6B                    rtl   
0895 3537
0896 3537              ;LocalBRegSave  ds 2
0897 3537
0898 3537
0899 3537                       ENDP 
0900 3537
0901 3537
0902 3537                       title 'Desk Manager--desk/DESK.UTILS' 
0903 3537              ;               copy desk/desk.utils
0904 3537              ****************************************************************
0905 3537              *
0906 3537              * Desk Utility Routines
0907 3537              *
0908 3537              * Change History
0909 3537              *
0910 3537              * 02 Oct 87             Steven Glass
0911 3537              *
0912 3537              * Changes were made to get these to work with new global data
0913 3537              * structures.  The DerefNDAHandle routine no longer
0914 3537              * locks the handle (we assume that it is already locked)
0915 3537              *
0916 3537              * UnlockNDAHandle was removed (it was never called).
0917 3537              *
0918 3537              * A number of start/end's were combined into one.
0919 3537              *
0920 3537              *
0921 3537              ****************************************************************
0922 3537              DeskUtils PROC EXPORT 
0923 3537
0924 3537              ;----------------------------------------------------
0925 3537              ;
0926 3537              ; DerefNDAList
0927 3537              ;
0928 3537              ; Locks the NDAListHandle and deref's it into
0929 3537              ; NDAListPtr
0930 3537
0931 3537
0932 3537                       EXPORT DerefNDAList 
0933 3537              DerefNDAList  
0934 3537 AF 6E 1D E0           lda   >EntryCount
0935 353B 1A                    inc   a
0936 353C 8F 6E 1D E0           sta   >EntryCount
0937 3540
0938 3540 A0 04 00              ldy   #4
0939 3543 B7 15                 lda   [NDAListHandle],y
0940 3545 09 00 80              ora   #$8000                   ;lock the handle
0941 3548 97 15                 sta   [NDAListHandle],y
0942 354A 88                    dey   
0943 354B 88                    dey   
0944 354C B7 15                 lda   [NDAListHandle],y
0945 354E 85 03                 sta   NDAListPtr+2
0946 3550 A7 15                 lda   [NDAListHandle]
0947 3552 85 01                 sta   NDAListPtr
0948 3554
0949 3554 60                    rts   
0950 3555
0951 3555              ;----------------------------------------------------
0952 3555              ;
0953 3555              ; UnlockNDAList
0954 3555              ;
0955 3555              ; Unlocks the NDAList handle.
0956 3555
0957 3555                       EXPORT UnlockNDAList 
0958 3555              UnlockNDAList  
0959 3555 AF 6E 1D E0           lda   >EntryCount
0960 3559 3A                    dec   a
0961 355A 8F 6E 1D E0           sta   >EntryCount
0962 355E D0 0A                 bne   LeaveItLocked
0963 3560
0964 3560 A0 04 00              ldy   #4
0965 3563 B7 15                 lda   [NDAListHandle],y
0966 3565 29 FF 7F              and   #$7FFF
0967 3568 97 15                 sta   [NDAListHandle],y
0968 356A
0969 356A              LeaveItLocked  
0970 356A 60                    rts   
0971 356B
0972 356B              ;----------------------------------------------------
0973 356B              ;
0974 356B              ; DerefNDAHandle
0975 356B              ;
0976 356B              ; Derefs but does not bother locking the handle to
0977 356B              ; the NDA.
0978 356B              ;
0979 356B
0980 356B                       EXPORT DerefNDAHandle  
0981 356B A0 02 00     DerefNDAHandle ldy   #2
0982 356E B7 0D                 lda   [NDAHandle],y
0983 3570 85 13                 sta   NDAPtr+2
0984 3572 A7 0D                 lda   [NDAHandle]
0985 3574 85 11                 sta   NDAPtr
0986 3576 60                    rts   
0987 3577
0988 3577                       ENDP 
0989 3577
0990 3577
0991 3577              ****************************************************************
0992 3577              *
0993 3577              * FindThisWindow
0994 3577              *
0995 3577              * Inputs
0996 3577              *       a-reg:  low word of window ptr to look for
0997 3577              *       x-reg:  high word of window ptr to look for
0998 3577              *
0999 3577              * Outputs:
1000 3577              *   carry:  set if window is found
1001 3577              *           clear if window is not found
1002 3577              *   DPage:
1003 3577              *     OffsetToThisOne & PtrToThisOne set to point into
1004 3577              *     global data.
1005 3577              *
1006 3577              * We search through the NDAList for an NDA with a window ptr
1007 3577              * equal to the one passed in the a and x register.
1008 3577              *
1009 3577              * If we find it, we return with the carry set and the
1010 3577              * variables OffsetToThisOne and PtrToThisOne set on zero page.
1011 3577              *
1012 3577              * If we do not find it we return with carry clear.
1013 3577              *
1014 3577              * 
1015 3577              * Change History
1016 3577              *
1017 3577              * 02 Oct 87             Steven Glass
1018 3577              *
1019 3577              * Changes were made to get this to work with new global data
1020 3577              * structures.
1021 3577              *
1022 3577              ****************************************************************
1023 3577              FindThisWindow PROC EXPORT 
1024 3577
1025 3577 DA                    phx                            ; store the pointer on the stack
1026 3578 48                    pha                            ;
1027 3579
1028 3579              *** added 19-Feb-91 DAL
1029 3579 8F 0F 3B 02           sta   >DeskGlobalWindow
1030 357D 8A                    txa   
1031 357E 8F 11 3B 02           sta   >DeskGlobalWindow+2
1032 3582              *** end of 19-Feb-91 DAL
1033 3582
1034 3582 A0 0E 00              ldy   #SizeOfDeskGlobals       ; y points to first NDA record
1035 3585 A2 01 00              ldx   #1                       ; x is count
1036 3588
1037 3588 8A           KeepLooking txa                         ; compare count to num scrap records
1038 3589 C7 01                 cmp   [NDAListPtr]
1039 358B F0 02                 beq   LastItem
1040 358D B0 37                 bcs   NotInTable
1041 358F
1042 358F 98           LastItem tya   
1043 3590 18                    clc   
1044 3591 69 1A 00              adc   #o_WindowPtr
1045 3594 A8                    tay   
1046 3595 B7 01                 lda   [NDAListPtr],y           ; get the type of this scrap record
1047 3597 C8                    iny                            ; bump y before compare
1048 3598 C8                    iny   
1049 3599 C3 01                 cmp   1,s                      ; compare to value on stack
1050 359B D0 06                 bne   NotThisOne
1051 359D B7 01                 lda   [NDAListPtr],y
1052 359F C3 03                 cmp   3,s
1053 35A1 F0 09                 beq   FoundIt
1054 35A3
1055 35A3 98           NotThisOne tya                          ; bump y by size of record
1056 35A4 18                    clc                            ; minus what we've already bumped
1057 35A5 69 08 00              adc   #NDARecSize-o_WindowPtr-2
1058 35A8 A8                    tay   
1059 35A9 E8                    inx                            ; bump count by 1
1060 35AA 80 DC                 bra   KeepLooking
1061 35AC
1062 35AC
1063 35AC 68           FoundIt  pla                            ; clear pointer off stack
1064 35AD 68                    pla   
1065 35AE 98                    tya                            ; fix Offset To this one by subtracting
1066 35AF 38                    sec                            ; off the extra we just added to get to
1067 35B0 E9 1C 00              sbc   #o_WindowPtr+2           ; window ptr.
1068 35B3 85 05                 sta   OffsetToThisOne
1069 35B5 64 07                 stz   OffsetToThisOne+2
1070 35B7 A5 01                 lda   NDAListPtr
1071 35B9 18                    clc   
1072 35BA 65 05                 adc   OffsetToThisOne
1073 35BC 85 09                 sta   PtrToThisOne
1074 35BE A5 03                 lda   NDAListPtr+2
1075 35C0 65 07                 adc   OffsetToThisOne+2
1076 35C2 85 0B                 sta   PtrToThisOne+2
1077 35C4 38                    sec   
1078 35C5 60                    rts   
1079 35C6
1080 35C6              *** 19-Feb-91 DAL
1081 35C6              *** Call GetAuxWindInfo and grab a pointer to the NDA-like structure from there, if any.
1082 35C6              *** Window pointer is still on stack.
1083 35C6
1084 35C6 FA           NotInTable plx   
1085 35C7 68                    pla   
1086 35C8 5A                    phy   
1087 35C9 5A                    phy                            ;space for GetAuxWindInfo result
1088 35CA 48                    pha   
1089 35CB DA                    phx                            ;pushed window pointer
1090 35CC
1091 35CC              ;	pha		;space for GetWKind result
1092 35CC              ;	pha
1093 35CC              ;	phx		;pushed second copy of window pointer
1094 35CC              ;	_GetWKind
1095 35CC              ;	pla
1096 35CC              ;	bpl	@appWindow
1097 35CC              *** 16-Apr-91 DAL -- calling GetWKind trashes some WM direct page, so look in the record directly
1098 35CC              *** (the system-window bit is bit 31 of the window's port's pixelMap pointer!)
1099 35CC 0B                    phd   
1100 35CD 48                    pha   
1101 35CE DA                    phx   
1102 35CF 3B                    tsc   
1103 35D0 5B                    tcd   
1104 35D1 A0 04 00              ldy   #4
1105 35D4 B7 01                 lda   [1],y
1106 35D6 FA                    plx   
1107 35D7 FA                    plx   
1108 35D8 2B                    pld   
1109 35D9 AA                    tax   
1110 35DA 10 2D                 bpl   @appWindow
1111 35DC              *** end of 16-Apr-91 DAL
1112 35DC
1113 35DC A2 0E 63 22           _GetAuxWindInfo 
1114 35E3 68                    pla   
1115 35E4 FA                    plx   
1116 35E5 B0 26                 bcs   @notfound
1117 35E7
1118 35E7 0B                    phd   
1119 35E8 DA                    phx   
1120 35E9 48                    pha   
1121 35EA 3B                    tsc   
1122 35EB 5B                    tcd   
1123 35EC A0 18 00              ldy   #24                      ;offset into aux wind info of NDAStruct
1124 35EF B7 01                 lda   [1],y
1125 35F1 AA                    tax   
1126 35F2 C8                    iny   
1127 35F3 C8                    iny   
1128 35F4 B7 01                 lda   [1],y                    ;NDAStruct pointer in AX
1129 35F6 7A                    ply   
1130 35F7 7A                    ply   
1131 35F8 2B                    pld   
1132 35F9
1133 35F9 A8                    tay   
1134 35FA D0 03                 bne   @found
1135 35FC 9B                    txy   
1136 35FD F0 0E                 beq   @notfound
1137 35FF
1138 35FF 85 0B        @found   sta   <PtrToThisOne+2          ;not nil--return it in PtrToThisOne
1139 3601 86 09                 stx   <PtrToThisOne
1140 3603 64 05                 stz   <OffsetToThisOne
1141 3605 64 07                 stz   <OffsetToThisOne+2       ;make sure nobody's using this!
1142 3607 38                    sec   
1143 3608 60                    rts   
1144 3609
1145 3609 68           @appWindow pla   
1146 360A 68                    pla   
1147 360B 68                    pla   
1148 360C 68                    pla   
1149 360D 18           @notfound clc   
1150 360E 60                    rts   
1151 360F
1152 360F                       export DeskGlobalWindow 
1153 360F 00 00 00 00  DeskGlobalWindow DC L:0
1154 3613
1155 3613                       ENDP 
1156 3613
1157 3613              ****************************************************************
1158 3613              *
1159 3613              * AreWeTop
1160 3613              *
1161 3613              * Decides if the top window is a system window.  If it is
1162 3613              * then AreWeTop returns with carry set.  If the top window
1163 3613              * is not a system window, then AreWeTop returns with carry
1164 3613              * clear.
1165 3613              *
1166 3613              * Additionally, if the window is a system window, I call
1167 3613              * find this window which sets up PtrToThisOne.  FindThisWindow
1168 3613              * must also succeed for AreWeTop to return true.
1169 3613              *
1170 3613              *
1171 3613              * Change History
1172 3613              *
1173 3613              * 02 Oct 87             Steven Glass
1174 3613              *
1175 3613              * No changes were needed for new data structures but
1176 3613              * I changed a PushLong #0 to pha pha to save space.
1177 3613              *
1178 3613              * 15 mar 89         Steven Glass
1179 3613              *
1180 3613              * Uses FrontToAX instead of calling FrontWindow directly
1181 3613              * saving lots of code.
1182 3613              *
1183 3613              * Also branch directly to FindThisWindow rather than
1184 3613              * jsr followed by rts.  This saves more code.
1185 3613              *
1186 3613              ****************************************************************
1187 3613              AreWeTop PROC EXPORT 
1188 3613
1189 3613
1190 3613 20 E2 3B              jsr   FrontToAX
1191 3616 A8                    tay   
1192 3617 D0 05                 bne   FindthisWindow0
1193 3619 9B                    txy   
1194 361A D0 02                 bne   FindThisWindow0
1195 361C
1196 361C 18           NotSystem clc   
1197 361D 60                    rts   
1198 361E
1199 361E              FindThisWindow0  
1200 361E 82 56 FF              brl   FindThisWindow           ;DAL
1201 3621
1202 3621                       ENDP 
1203 3621
1204 3621
1205 3621              ****************************************************************
1206 3621              *
1207 3621              FutzResIDs proc 
1208 3621              *
1209 3621              * Two routines here are used to set and restore the Resource
1210 3621              * Manager's current Resource App.
1211 3621              *
1212 3621              * These calls are meant to be made around calls to the
1213 3621              * NDA.  Example:
1214 3621              *
1215 3621              *                   jsr SetResID
1216 3621              *                   send msg to NDA
1217 3621              *                   jsr RepResID
1218 3621              *
1219 3621              * The first call puts the current resID on the stack,
1220 3621              * The second call pulls it off.
1221 3621              *
1222 3621              *
1223 3621              * Inputs:
1224 3621              *                   none
1225 3621              *
1226 3621              * Outputs:
1227 3621              *                   none
1228 3621              *
1229 3621              * External Refs:
1230 3621              *                   none
1231 3621              *
1232 3621              * Entry Points:
1233 3621                       Export SetResID 
1234 3621                       Export RepResID 
1235 3621              *
1236 3621                       longa on                       ; mode
1237 3621                       longi on
1238 3621              *
1239 3621              * Change History
1240 3621              *
1241 3621              * 01 Mar 89         Steven Glass & Harry Yee
1242 3621              *
1243 3621              * Harry scolds steve and tells him that you cannot call the 
1244 3621              * resource manager and expect it to work, if the resource 
1245 3621              * manager is not there.
1246 3621              *
1247 3621              * No disk other that 4.1 worked at all.
1248 3621              *
1249 3621              ****************************************************************
1250 3621
1251 3621 FA           SetResID plx                            ; make room on the stack above
1252 3622 48                    pha                            ; the rts
1253 3623 DA                    phx   
1254 3624
1255 3624 F4 00 00              pea   0                        ; call resource status
1256 3627 A2 1E 06 22           _ResourceStatus 
1257 362E 68                    pla                            ; get result in a-reg
1258 362F B0 1A                 bcs   @Done                    ; carry set means got dispatch error
1259 3631 F0 18                 beq   @Done                    ; 0 means resource manager not active
1260 3633
1261 3633 48                    pha                            ; get the current res app id
1262 3634 A2 1E 14 22           _GetCurResourceApp 
1263 363B 68                    pla   
1264 363C 83 03                 sta   3,s                      ; put it on the stack above the RTS
1265 363E
1266 363E A0 22 00              ldy   #o_UserID                ; set the id of the NDA about to be called
1267 3641 B7 09                 lda   [PtrToThisOne],y
1268 3643 48                    pha   
1269 3644 A2 1E 13 22           _SetCurResourceApp 
1270 364B
1271 364B 60           @Done    rts                            ; done
1272 364C
1273 364C
1274 364C
1275 364C
1276 364C FA           RepResID plx                            ; pull off the old ID and put back
1277 364D 68                    pla   
1278 364E DA                    phx                            ; the rts addr
1279 364F 48                    pha                            ; save id on this side of rts adr
1280 3650
1281 3650 F4 00 00              pea   0                        ; call status
1282 3653 A2 1E 06 22           _ResourceStatus 
1283 365A 68                    pla                            ; get status result
1284 365B FA                    plx                            ; get id off stack
1285 365C A8                    tay                            ; set the zero bit of processor
1286 365D B0 0A                 bcs   @Done
1287 365F F0 08                 beq   @Done
1288 3661
1289 3661
1290 3661
1291 3661 DA                    phx                            ; push id now in x-reg
1292 3662 A2 1E 13 22           _SetCurResourceApp 
1293 3669
1294 3669 60           @Done    rts                            ; done.
1295 366A
1296 366A                       ENDP 
1297 366A
1298 366A
1299 366A              ****************************************************************
1300 366A              *
1301 366A              SendOpen PROC EXPORT 
1302 366A              *
1303 366A              * This routine transfers control to the open routine of the
1304 366A              * DA pointed to by PointerToThisOne.  All registers and
1305 366A              * relative stack locations are preserved.  Control returns
1306 366A              * from the DA to the Calling routine, not here.
1307 366A              *
1308 366A              *
1309 366A              *
1310 366A              * Inputs:
1311 366A              *                   a, x and y are all passed on to the NDA
1312 366A              *                   unchanged.
1313 366A              *
1314 366A              * Outputs:
1315 366A              *                   none
1316 366A              *
1317 366A              * External Refs:
1318 366A              *                   none
1319 366A              *
1320 366A              * Entry Points:
1321 366A                       ENTRY SendSomething 
1322 366A              *
1323 366A                       longa on                       ; mode
1324 366A                       longi on
1325 366A              *
1326 366A              * Change History
1327 366A              *
1328 366A              * 02 Oct 87             Steven Glass
1329 366A              *
1330 366A              * No chnages were necessary to support the new data structures.
1331 366A              *
1332 366A              * 19 Feb 89         Steven Glass
1333 366A              *
1334 366A              * All the send routines ended the same way, so they now 
1335 366A              * share code with SendOpen.  The new entry point is SendSomething.
1336 366A              *
1337 366A              ****************************************************************
1338 366A
1339 366A
1340 366A              s_YReg   equ   1
1341 366A              s_AReg   equ   3
1342 366A              s_AdrForOpen equ   5
1343 366A
1344 366A 48                    pha                            ; put 3 bytes on stack
1345 366B 8B                    phb                            ; for addr of action routine
1346 366C
1347 366C 48                    pha                            ; save a
1348 366D 5A                    phy                            ; save y
1349 366E
1350 366E A0 03 00              ldy   #o_Open+1                ; get addr from table
1351 3671
1352 3671              SendSomething  
1353 3671 B7 09                 lda   [PtrToThisOne],y
1354 3673 83 06                 sta   s_AdrForOpen+1,s
1355 3675 88                    dey   
1356 3676 B7 09                 lda   [PtrToThisOne],y         ; rtl adds 1 so sub 1
1357 3678 3A                    dec   a
1358 3679 83 05                 sta   s_AdrForOpen,s
1359 367B
1360 367B 7A                    ply   
1361 367C 68                    pla   
1362 367D
1363 367D 6B                    rtl   
1364 367E
1365 367E                       ENDP 
1366 367E
1367 367E
1368 367E              ****************************************************************
1369 367E              *
1370 367E              * SendClose
1371 367E              *
1372 367E              * This routine transfers control to the close routine of the
1373 367E              * DA pointed to by PointerToThisOne.  All registers and
1374 367E              * relative stack locations are preserved.  Control returns
1375 367E              * from the DA to the Calling routine, not here.
1376 367E              *
1377 367E              *
1378 367E              *
1379 367E              * Change History
1380 367E              *
1381 367E              * 02 Oct 87             Steven Glass
1382 367E              *
1383 367E              * No chnages were necessary to support the new data structures.
1384 367E              *
1385 367E              ****************************************************************
1386 367E              SendClose PROC EXPORT 
1387 367E
1388 367E              s_YReg   equ   1
1389 367E              s_AReg   equ   3
1390 367E              s_AdrForClose equ   5
1391 367E
1392 367E 48                    pha                            ; put 3 bytes on stack
1393 367F 8B                    phb                            ; for addr of action routine
1394 3680
1395 3680 48                    pha                            ; save a
1396 3681 5A                    phy                            ; save y
1397 3682
1398 3682 A0 07 00              ldy   #o_Close+1               ; get addr from table
1399 3685 80 EA                 bra   SendSomething
1400 3687
1401 3687                       ENDP 
1402 3687
1403 3687
1404 3687              ****************************************************************
1405 3687              *
1406 3687              * SendInit
1407 3687              *
1408 3687              * This routine transfers control to the init routine of the
1409 3687              * DA pointed to by PointerToThisOne.  All registers and
1410 3687              * relative stack locations are preserved.  Control returns
1411 3687              * from the DA to the Calling routine, not here.
1412 3687              *
1413 3687              *
1414 3687              *
1415 3687              * Change History
1416 3687              *
1417 3687              * 02 Oct 87             Steven Glass
1418 3687              *
1419 3687              * No chnages were necessary to support the new data structures.
1420 3687              *
1421 3687              ****************************************************************
1422 3687              SendInit PROC EXPORT 
1423 3687
1424 3687              s_YReg   equ   1
1425 3687              s_AReg   equ   3
1426 3687              s_AdrForInit equ   5
1427 3687
1428 3687 48                    pha                            ; put 3 bytes on stack
1429 3688 8B                    phb                            ; for addr of action routine
1430 3689
1431 3689 48                    pha                            ; save a
1432 368A 5A                    phy                            ; save y
1433 368B
1434 368B A0 0F 00              ldy   #o_Init+1                ; get addr from table
1435 368E 80 E1                 bra   SendSomething
1436 3690
1437 3690                       ENDP 
1438 3690
1439 3690
1440 3690              ****************************************************************
1441 3690              *
1442 3690              * SendAction
1443 3690              *
1444 3690              * Inputs
1445 3690              *    All-registers
1446 3690              *    PtrToThisOne
1447 3690              *
1448 3690              * Output
1449 3690              *    Depends on routine called.
1450 3690              *
1451 3690              * This routine transfers control to the action routine of the
1452 3690              * DA pointed to by PointerToThisOne.  All registers and
1453 3690              * relative stack locations are preserved.  Control returns
1454 3690              * from the DA to the Calling routine, not here.
1455 3690              *
1456 3690              *
1457 3690              * Change History
1458 3690              *
1459 3690              * 02 Oct 87             Steven Glass
1460 3690              *
1461 3690              * No chnages were necessary to support the new data structures.
1462 3690              *
1463 3690              ****************************************************************
1464 3690              SendAction PROC EXPORT 
1465 3690
1466 3690              s_YReg   equ   1
1467 3690              s_AReg   equ   3
1468 3690              s_AdrForAction equ   5
1469 3690
1470 3690 48                    pha                            ; put 3 bytes on stack
1471 3691 8B                    phb                            ; for addr of action routine
1472 3692
1473 3692 48                    pha                            ; save a
1474 3693 5A                    phy                            ; save y
1475 3694
1476 3694              *** 26-Jun-92 DAL -- Add stack-based dispatch option.  Set bit 31 of action pointer.
1477 3694              ;	ldy	#o_Action+1	; get addr from table
1478 3694              ;;	bra	SendSomething
1479 3694              ;;SendSomething	lda	[PtrToThisOne],y
1480 3694              ;	sta	s_AdrForOpen+1,s
1481 3694              ;	dey
1482 3694              ;	lda	[PtrToThisOne],y	; rtl adds 1 so sub 1
1483 3694              ;	dec	a
1484 3694              ;	sta	s_AdrForOpen,s
1485 3694              ;
1486 3694              ;	ply
1487 3694              ;	pla
1488 3694              ;
1489 3694              ;	rtl
1490 3694
1491 3694 A0 0C 00              ldy   #o_Action+2              ; get address from table
1492 3697 B7 09                 lda   [<PtrToThisOne],y
1493 3699 30 03                 bmi   @stack_dispatch
1494 369B 88                    dey                            ; Y = o_Action+1
1495 369C 80 D3                 bra   SendSomething            ; old way
1496 369E
1497 369E              *** A = code, YX = data value (sometimes event pointer)
1498 369E
1499 369E 7A           @stack_dispatch ply   
1500 369F 68                    pla   
1501 36A0
1502 36A0              *** strip 3 extra bytes off stack (we pushed them at beginning of SendAction)
1503 36A0 83 02                 sta   2,s
1504 36A2 8B                    phb   
1505 36A3 68                    pla   
1506 36A4 68                    pla   
1507 36A5
1508 36A5 F4 00 00              pea   0                        ;push result space
1509 36A8 48                    pha                            ;action code
1510 36A9 5A                    phy   
1511 36AA DA                    phx                            ;data/pointer
1512 36AB 22 B1 3B 02           jsl   @jump_action
1513 36AF 68                    pla                            ;get result into A
1514 36B0 6B                    rtl   
1515 36B1
1516 36B1 A0 0B 00     @jump_action ldy   #o_Action+1
1517 36B4 B7 09                 lda   [<PtrToThisOne],y
1518 36B6 48                    pha   
1519 36B7 8B                    phb   
1520 36B8 88                    dey   
1521 36B9 B7 09                 lda   [<PtrToThisOne],y
1522 36BB 3A                    dec   a
1523 36BC 83 01                 sta   1,s
1524 36BE 6B                    rtl   
1525 36BF              *** end 26-Jun-92
1526 36BF
1527 36BF                       ENDP 
1528 36BF
1529 36BF
1530 36BF              ****************************************************************
1531 36BF              *
1532 36BF              * StartNDACall
1533 36BF              *
1534 36BF              * Inputs:
1535 36BF              *    A-reg:  Low word of WAP value
1536 36BF              *    Y-reg:  High word of WAP value
1537 36BF              *
1538 36BF              * Outputs
1539 36BF              *    D-reg:  set to place on stack
1540 36BF              *    b-reg:  set to code bank (k)
1541 36BF              *    a-reg, x-reg and y-reg are trashed.
1542 36BF              *
1543 36BF              * Side Effects:
1544 36BF              *
1545 36BF              *    busy flag is incremented.
1546 36BF              *
1547 36BF              *
1548 36BF              * This routine sets up direct page, adjusts the stack and
1549 36BF              * data bank, calls IncBusyFlag in preperation for the
1550 36BF              * start of a NDA Calls.
1551 36BF              *
1552 36BF              * It also leaves the WAP value (the handle to the global
1553 36BF              * data structure) in the NDAListHandle field on direct page.
1554 36BF              *
1555 36BF              *
1556 36BF              *
1557 36BF              * Change History
1558 36BF              *
1559 36BF              * 02 Oct 87             Steven Glass
1560 36BF              *
1561 36BF              * Changes were necessary to support the new data structures.  The
1562 36BF              * A & Y registers contain the WAP value for this tool.
1563 36BF              *
1564 36BF              ****************************************************************
1565 36BF              StartNDACall PROC EXPORT 
1566 36BF
1567 36BF FA                    plx                            ; get rts adr in x
1568 36C0
1569 36C0 0B                    phd                            ; save direct reg
1570 36C1
1571 36C1 5A                    phy                            ; this is the handle to the
1572 36C2 48                    pha                            ; global data structure.
1573 36C3
1574 36C3 3B                    tsc                            ; and get my zero page off stack
1575 36C4 38                    sec   
1576 36C5 E9 14 00              sbc   #StdZPSize-4
1577 36C8 1B                    tcs   
1578 36C9 5B                    tcd   
1579 36CA
1580 36CA 8B                    phb                            ; save data bank
1581 36CB 4B                    phk                            ; set data bank to
1582 36CC AB                    plb                            ; code bank
1583 36CD
1584 36CD
1585 36CD 22 64 00 E1           jsl   IncBusyFlg
1586 36D1
1587 36D1 DA                    phx                            ; put rts adr back on stack
1588 36D2 60                    rts   
1589 36D3
1590 36D3                       ENDP 
1591 36D3
1592 36D3
1593 36D3
1594 36D3
1595 36D3              ****************************************************************
1596 36D3              *
1597 36D3              * EndNDACall
1598 36D3              *
1599 36D3              * Inputs:
1600 36D3              *     None
1601 36D3              *
1602 36D3              * Outputs:
1603 36D3              *     None, but the x-register is preserved!
1604 36D3              *
1605 36D3              * This routine restores direct page and data bank, and adjusts
1606 36D3              * the stack and calls DecBusyFlg to undo everything that 
1607 36D3              * StartNDACall did.
1608 36D3              *
1609 36D3              *
1610 36D3              *
1611 36D3              * Change History
1612 36D3              *
1613 36D3              * 02 Oct 87             Steven Glass
1614 36D3              *
1615 36D3              * Changes were made to support the new data structures.  This 
1616 36D3              * routine now undoes everything done by the StartNDACall including
1617 36D3              * the busyflag and the direct page.
1618 36D3              *
1619 36D3              ****************************************************************
1620 36D3              EndNDACall PROC EXPORT 
1621 36D3
1622 36D3 7A                    ply                            ; save rts adr in y
1623 36D4
1624 36D4 AB                    plb                            ; restore data bank
1625 36D5 3B                    tsc                            ; adjust stack
1626 36D6 18                    clc   
1627 36D7 69 18 00              adc   #StdZPSize
1628 36DA 1B                    tcs   
1629 36DB
1630 36DB 2B                    pld                            ; restore direct page
1631 36DC
1632 36DC
1633 36DC 5A                    phy                            ; put rts back on stack
1634 36DD
1635 36DD 22 68 00 E1           jsl   DecBusyFlg
1636 36E1
1637 36E1 60                    rts   
1638 36E2
1639 36E2                       ENDP 
1640 36E2
1641 36E2
1642 36E2              ****************************************************************
1643 36E2              *
1644 36E2              FrontToAX PROC export 
1645 36E2              *
1646 36E2              * Returns the pointer to the front window to in the A & X 
1647 36E2              * registers.
1648 36E2              *
1649 36E2              *
1650 36E2              * Inputs:
1651 36E2              *                   none
1652 36E2              *
1653 36E2              * Outputs:
1654 36E2              *                   a-reg
1655 36E2              *                   x-reg
1656 36E2              *
1657 36E2              * External Refs:
1658 36E2              *                   none
1659 36E2              *
1660 36E2              * Entry Points:
1661 36E2              *                   none
1662 36E2              *
1663 36E2                       longa on                       ; mode
1664 36E2                       longi on
1665 36E2              *
1666 36E2              ****************************************************************
1667 36E2 48                    pha   
1668 36E3 48                    pha   
1669 36E4 A2 0E 15 22           _FrontWindow 
1670 36EB 68                    pla   
1671 36EC FA                    plx   
1672 36ED 60                    rts   
1673 36EE
1674 36EE                       ENDP 
1675 36EE
1676 36EE
1677 36EE              ****************************************************************
1678 36EE              *
1679 36EE              * CloseNDAbyWinPtr
1680 36EE              *
1681 36EE              *     Input     WinPtr
1682 36EE              *
1683 36EE              *
1684 36EE              * Stack looks like:
1685 36EE              *
1686 36EE              *      WinPtr
1687 36EE              *      =================
1688 36EE              *                         <- SP
1689 36EE              *
1690 36EE              *
1691 36EE              *
1692 36EE              * Change History
1693 36EE              *
1694 36EE              * 02 Oct 87             Steven Glass
1695 36EE              *
1696 36EE              * No changes were needed here to use the new structure of the 
1697 36EE              * NDAGlobals record.
1698 36EE              *
1699 36EE              * However, I changed the error exit and normal exit
1700 36EE              * routines to share code.
1701 36EE              *
1702 36EE              ****************************************************************
1703 36EE              CloseNDAbyWinPtr PROC EXPORT 
1704 36EE
1705 36EE                       DSect OrigDirect+2 
1706 36EE              RTL1     block 3 
1707 36EE              RTL2     block 3 
1708 36EE              WinPtr   long 
1709 36EE
1710 36EE 20 BF 3B              jsr   StartNDACall
1711 36F1 20 37 3A              jsr   DerefNDAList
1712 36F4
1713 36F4 A5 21                 lda   WinPtr
1714 36F6 A6 23                 ldx   WinPtr+2
1715 36F8 20 77 3A              jsr   FindThisWindow
1716 36FB 90 12                 bcc   CannotFind
1717 36FD
1718 36FD 20 A4 3C              jsr   DoCloseStuff
1719 3700
1720 3700 A2 00 00              ldx   #0
1721 3703 DA           JoinExit phx   
1722 3704 20 55 3A              jsr   UnlockNDAList
1723 3707 FA                    plx   
1724 3708 20 D3 3B              jsr   EndNDACall
1725 370B
1726 370B 5C 3E 1D 02           jml   oErrOut4
1727 370F
1728 370F A2 11 05     CannotFind ldx   #NotSysWindow
1729 3712 80 EF                 bra   JoinExit
1730 3714
1731 3714                       ENDP 
1732 3714
1733 3714
1734 3714              ****************************************************************
1735 3714              *
1736 3714              * CloseAllNDAs
1737 3714              *
1738 3714              *     Input     none
1739 3714              *
1740 3714              *
1741 3714              * Change History
1742 3714              *
1743 3714              * 02 Oct 87             Steven Glass
1744 3714              *
1745 3714              * No changes were needed here to use the new structure of the 
1746 3714              * NDAGlobals record.
1747 3714              *
1748 3714              * However, I changed the code to use the stack to hold a counter
1749 3714              * instead of storage in line.
1750 3714              *
1751 3714              ****************************************************************
1752 3714              CloseAllNDAs2 PROC EXPORT 
1753 3714
1754 3714 20 BF 3B              jsr   StartNDACall
1755 3717 20 37 3A              jsr   DerefNDAList
1756 371A
1757 371A F4 00 00              PushWord #0                    ; init counter on stack
1758 371D
1759 371D A5 01                 lda   NDAListPtr
1760 371F 18                    clc   
1761 3720 69 0E 00              adc   #SizeOfDeskGlobals
1762 3723 85 09                 sta   PtrToThisOne
1763 3725 A5 03                 lda   NDAListPtr+2
1764 3727 90 01                 bcc   NoCarry1
1765 3729 1A                    inc   a
1766 372A 85 0B        NoCarry1 sta   PtrToThisOne+2
1767 372C
1768 372C A3 01        Loop     lda   1,s
1769 372E C7 01                 cmp   [NDAListPtr]
1770 3730 B0 18                 bcs   AllDone
1771 3732
1772 3732 A7 09                 lda   [PtrToThisOne]
1773 3734 F0 03                 beq   NotOpen
1774 3736
1775 3736 20 A4 3C              jsr   DoCloseStuff
1776 3739
1777 3739 A5 09        NotOpen  lda   PtrToThisOne
1778 373B 18                    clc   
1779 373C 69 24 00              adc   #NDARecSize
1780 373F 85 09                 sta   PtrToThisOne
1781 3741 90 02                 bcc   NoCarry2
1782 3743 E6 0B                 inc   PtrToThisOne+2
1783 3745              NoCarry2  
1784 3745              ;	lda	1,s
1785 3745              ;	inc	a
1786 3745              ;	sta	1,s
1787 3745 68                    pla                            ;2-May-91 DAL
1788 3746 1A                    inc   a                        ;2-May-91 DAL
1789 3747 48                    pha                            ;2-May-91 DAL
1790 3748
1791 3748 80 E2                 bra   Loop
1792 374A
1793 374A 68           AllDone  pla                            ; clean off the stack
1794 374B
1795 374B              *** added 2-May-91 DAL -- walk the window list, closing non-NDA system windows
1796 374B F4 00 00              pea   0
1797 374E A2 0E 06 22           _WindStatus 
1798 3755 68                    pla   
1799 3756 F0 42                 beq   @noWindows
1800 3758
1801 3758 48           @anotherPass pha   
1802 3759 48                    pha   
1803 375A A2 0E 52 22           _GetFirstWindow 
1804 3761
1805 3761 A3 02        @nextWindow lda   2,s
1806 3763 F0 33                 beq   @noMoreWindows
1807 3765
1808 3765 48                    pha                            ;space for GetWKind result
1809 3766 A3 05                 lda   5,s
1810 3768 48                    pha   
1811 3769 A3 05                 lda   5,s
1812 376B 48                    pha                            ;pushed a copy of window pointer
1813 376C A2 0E 2B 22           _GetWKind 
1814 3773 68                    pla   
1815 3774 10 13                 bpl   @advanceToNext
1816 3776
1817 3776 A3 03        @isSysWindow lda   3,s
1818 3778 48                    pha   
1819 3779 A3 03                 lda   3,s
1820 377B 48                    pha                            ;keep a copy of the window pointer in case Close fails
1821 377C A2 05 1C 22           _CloseNDAByWinPtr 
1822 3783 B0 04                 bcs   @advanceToNext
1823 3785 68                    pla   
1824 3786 68                    pla   
1825 3787 80 CF                 bra   @anotherPass
1826 3789
1827 3789 A3 03        @advanceToNext lda   3,s
1828 378B 48                    pha   
1829 378C A3 03                 lda   3,s
1830 378E 48                    pha                            ;made space for result
1831 378F A2 0E 2A 22           _GetNextWindow 
1832 3796 80 C9                 bra   @nextWindow
1833 3798
1834 3798 68           @noMoreWindows pla   
1835 3799 68                    pla   
1836 379A              @noWindows  
1837 379A              *** end of 2-May-91 DAL
1838 379A
1839 379A 20 55 3A              jsr   UnlockNDAList
1840 379D 20 D3 3B              jsr   EndNDACall
1841 37A0 5C 0B 1D 02           jml   oEndCall0
1842 37A4
1843 37A4                       ENDP 
1844 37A4
1845 37A4
1846 37A4              ****************************************************************
1847 37A4              *
1848 37A4              * DoCloseStuff
1849 37A4              *
1850 37A4              * This is a routine that is shared by CloseNDA and
1851 37A4              * by SystemClick for close the NDAs.
1852 37A4              *
1853 37A4              *
1854 37A4              * Change History
1855 37A4              *
1856 37A4              * 02 Oct 87             Steven Glass
1857 37A4              *
1858 37A4              * No changes required to support new data structures.
1859 37A4              *
1860 37A4              ****************************************************************
1861 37A4              DoCloseStuff PROC EXPORT 
1862 37A4 20 21 3B              jsr   SetResID
1863 37A7
1864 37A7 22 7E 3B 02           jsl   SendClose
1865 37AB
1866 37AB 20 4C 3B              jsr   RepResID
1867 37AE
1868 37AE A0 1A 00              ldy   #o_WindowPtr
1869 37B1 A9 00 00              lda   #0
1870 37B4 97 09                 sta   [PtrToThisOne],y
1871 37B6 C8                    iny   
1872 37B7 C8                    iny   
1873 37B8 97 09                 sta   [PtrToThisOne],y
1874 37BA
1875 37BA A9 00 00              lda   #0                       ; the the status word
1876 37BD 87 09                 sta   [PtrToThisOne]
1877 37BF
1878 37BF 60                    rts   
1879 37C0
1880 37C0                       ENDP 
1881 37C0
1882 37C0
1883 37C0
1884 37C0              ****************************************************************
1885 37C0              *
1886 37C0              * SystemTask
1887 37C0              *
1888 37C0              * This is the routine that an application must call
1889 37C0              * periodically to keep desk accessories alive.  The suggestion
1890 37C0              * is that applications call this routine every time through
1891 37C0              * the main event loop.
1892 37C0              *
1893 37C0              * This routine also makes the CURSOR calls to the da that
1894 37C0              * is the front window.
1895 37C0              *
1896 37C0              * Change History
1897 37C0              *
1898 37C0              * 02 Oct 87             Steven Glass
1899 37C0              *
1900 37C0              * Changes were made here to use the new structure of the 
1901 37C0              * NDAGlobals record.
1902 37C0              *
1903 37C0              * Additionally, the code that reads the tick count was changed
1904 37C0              * do turn interrupts off (rather than turning them on) while
1905 37C0              * the two words are read.  (The code did a cli rather than
1906 37C0              * an sei.)
1907 37C0              *
1908 37C0              ****************************************************************
1909 37C0              SystemTask PROC EXPORT 
1910 37C0
1911 37C0              TickCount equ   OffsetToThisOne         ; zp aliasing
1912 37C0
1913 37C0              *** added 21-Apr-91 DAL -- make SystemTask take no action if GS/OS is busy
1914 37C0 AA                    tax   
1915 37C1 AF BE 00 E1           lda   >$e100be
1916 37C5 10 05                 bpl   @1
1917 37C7 18                    clc   
1918 37C8 A9 00 00              lda   #0
1919 37CB 6B                    rtl   
1920 37CC 8A           @1       txa   
1921 37CD              *** end of 21-Apr-91 DAL
1922 37CD
1923 37CD 20 BF 3B              jsr   StartNDACall             ;inc busy flag
1924 37D0 20 37 3A              jsr   DerefNDAList             ;deref and lock handle to NDAListPtr
1925 37D3
1926 37D3              ;------------------------------------------------------
1927 37D3              ;
1928 37D3              ; first send cursor message if the front window is
1929 37D3              ; one of our windows.
1930 37D3              ;
1931 37D3 20 13 3B              jsr   AreWeTop                 ;is top window a system window?
1932 37D6 90 0D                 bcc   NotOnTop
1933 37D8
1934 37D8 20 21 3B              jsr   SetResID
1935 37DB
1936 37DB A9 03 00              lda   #DACursorCode
1937 37DE 22 90 3B 02           jsl   SendAction
1938 37E2
1939 37E2 20 4C 3B              jsr   RepResID
1940 37E5              ;------------------------------------------------------
1941 37E5              ;
1942 37E5              ; Now go through the list of open DA's and see if
1943 37E5              ; any need periodic wake ups
1944 37E5
1945 37E5              NotOnTop                                ; 
1946 37E5 A0 06 00              ldy   #o_TickAddress           ; put the address of the tick
1947 37E8 B7 01                 lda   [NDAListPtr],y           ; count on direct page.
1948 37EA 85 11                 sta   NDAPtr
1949 37EC C8                    iny   
1950 37ED C8                    iny   
1951 37EE B7 01                 lda   [NDAListPtr],y
1952 37F0 85 13                 sta   NDAPtr+2
1953 37F2
1954 37F2 08                    php                            ; ints off while accessing
1955 37F3 78                    sei   
1956 37F4 A7 11                 lda   [NDAPtr]
1957 37F6 85 05                 sta   TickCount
1958 37F8 A0 02 00              ldy   #2
1959 37FB B7 11                 lda   [NDAPtr],y
1960 37FD 85 07                 sta   TickCount+2
1961 37FF 28                    plp                            ; restore ints
1962 3800
1963 3800 A5 01                 lda   NDAListPtr               ; initialize PtrToThisOne
1964 3802 18                    clc   
1965 3803 69 0E 00              adc   #SizeOfDeskGlobals
1966 3806 85 09                 sta   PtrToThisOne
1967 3808 A5 03                 lda   NDAListPtr+2
1968 380A 69 00 00              adc   #0
1969 380D 85 0B                 sta   PtrToThisOne+2
1970 380F
1971 380F F4 00 00              pea   0                        ; put counter on stack
1972 3812
1973 3812 A3 01        Loop     lda   1,s                      ; is counter greater or equal num das
1974 3814 C7 01                 cmp   [NDAListPtr]
1975 3816 B0 58                 bcs   NDAsDone
1976 3818
1977 3818 A7 09                 lda   [PtrToThisOne]           ; see if it is open
1978 381A F0 43                 beq   NotThisOne
1979 381C
1980 381C
1981 381C A0 12 00              ldy   #o_Period                ; if period is $FFFF then it
1982 381F B7 09                 lda   [PtrToThisOne],y         ; does not want this shit
1983 3821 C9 FF FF              cmp   #$FFFF
1984 3824 F0 39                 beq   NotThisOne
1985 3826
1986 3826              ;------------------------------------------------------
1987 3826              ;
1988 3826              ; Calculate how many ticks since last service.
1989 3826              ;
1990 3826              ;    TickCount - LastServiced
1991 3826              ;
1992 3826              ; If result is negative, invert it (very unlikely since
1993 3826              ; it takes two years of constant running for the tick
1994 3826              ; count to wrap.
1995 3826              ;
1996 3826 A5 05                 lda   TickCount
1997 3828 38                    sec   
1998 3829 A0 16 00              ldy   #o_LastServiced
1999 382C F7 09                 sbc   [PtrToThisOne],y
2000 382E AA                    tax                            ; put result in x
2001 382F C8                    iny                            ; do rest of divide
2002 3830 C8                    iny   
2003 3831 A5 07                 lda   TickCount+2
2004 3833 F7 09                 sbc   [PtrToThisOne],y
2005 3835 10 06                 bpl   IsPos                    ; if this is pos then it is 0
2006 3837 8A                    txa                            ; if neg then we wrapped.
2007 3838 49 FF FF              eor   #$FFFF
2008 383B 1A                    inc   a
2009 383C AA                    tax   
2010 383D 8A           IsPos    txa                            ; get back from x and see
2011 383E A0 12 00              ldy   #o_Period                ; if this is greater than
2012 3841 D7 09                 cmp   [PtrToThisOne],y         ; period
2013 3843 90 1A                 bcc   NotThisOne
2014 3845
2015 3845              ;------------------------------------------------------
2016 3845              ;
2017 3845              ; It is greater than period so save new value for
2018 3845              ; last serviced.
2019 3845              ;
2020 3845 A0 16 00              ldy   #o_LastServiced          ; fix last serviced field in rec
2021 3848 A5 05                 lda   TickCount
2022 384A 97 09                 sta   [PtrToThisOne],y
2023 384C C8                    iny   
2024 384D C8                    iny   
2025 384E A5 07                 lda   TickCount+2
2026 3850 97 09                 sta   [PtrToThisOne],y
2027 3852
2028 3852 20 21 3B              jsr   SetResID
2029 3855
2030 3855 A9 02 00              lda   #DARunCode               ; send the run code to NDA
2031 3858 22 90 3B 02           jsl   SendAction
2032 385C
2033 385C 20 4C 3B              jsr   RepResID
2034 385F
2035 385F A5 09        NotThisOne lda   PtrToThisOne           ; now bump pointer to current da
2036 3861 18                    clc   
2037 3862 69 24 00              adc   #NDARecSize
2038 3865 85 09                 sta   PtrToThisOne
2039 3867 90 02                 bcc   NoCarry2
2040 3869 E6 0B                 inc   PtrToThisOne+2
2041 386B 68           NoCarry2 pla                            ; bump counter on stack
2042 386C 1A                    inc   a
2043 386D 48                    pha   
2044 386E 80 A2                 bra   Loop
2045 3870
2046 3870 68           NDAsDone pla                            ;remove counter from stack
2047 3871
2048 3871              ;-----------------------------------------------------------
2049 3871              ;
2050 3871              ;  Now check run queue
2051 3871              ;
2052 3871
2053 3871 A0 0A 00              ldy   #o_TaskQueueHeader       ;initialize PtrToThisOne for runQ
2054 3874 B7 01                 lda   [NDAListPtr],y
2055 3876 85 09                 sta   PtrToThisOne
2056 3878 C8                    iny   
2057 3879 C8                    iny   
2058 387A B7 01                 lda   [NDAListPtr],y
2059 387C 85 0B                 sta   PtrToThisOne+2
2060 387E
2061 387E A5 09        Loop1    lda   PtrToThisOne             ;check for nil address (end of list)
2062 3880 D0 04                 bne   Loop2
2063 3882 A5 0B                 lda   PtrToThisOne+2
2064 3884 F0 52                 beq   AllDone
2065 3886              Loop2     
2066 3886 A0 04 00              ldy   #o_RunPeriod             ; if period is $FFFF then it
2067 3889 B7 09                 lda   [PtrToThisOne],y         ; does not want this shit
2068 388B C9 FF FF              cmp   #$FFFF
2069 388E F0 3A                 beq   SkipThisOne
2070 3890
2071 3890              ;------------------------------------------------------
2072 3890              ;
2073 3890              ; Calculate how many ticks since last service.
2074 3890              ;
2075 3890              ;    TickCount - LastServiced
2076 3890              ;
2077 3890              ; If result is negative, invert it (very unlikely since
2078 3890              ; it takes two years of constant running for the tick
2079 3890              ; count to wrap.
2080 3890              ;
2081 3890 A5 05                 lda   TickCount
2082 3892 38                    sec   
2083 3893 A0 08 00              ldy   #o_RunService
2084 3896 F7 09                 sbc   [PtrToThisOne],y
2085 3898 AA                    tax                            ; put result in x
2086 3899 C8                    iny                            ; do rest of divide
2087 389A C8                    iny   
2088 389B A5 07                 lda   TickCount+2
2089 389D F7 09                 sbc   [PtrToThisOne],y
2090 389F 10 06                 bpl   IsPos1                   ; if this is pos then it is 0
2091 38A1 8A                    txa                            ; if neg then we wrapped.
2092 38A2 49 FF FF              eor   #$FFFF
2093 38A5 1A                    inc   a
2094 38A6 AA                    tax   
2095 38A7 8A           IsPos1   txa                            ; get back from x and see
2096 38A8 A0 04 00              ldy   #o_RunPeriod             ; if this is greater than
2097 38AB D7 09                 cmp   [PtrToThisOne],y         ; period
2098 38AD 90 1B                 bcc   SkipThisOne
2099 38AF
2100 38AF              ;------------------------------------------------------
2101 38AF              ;
2102 38AF              ; It is greater than period so save new value for
2103 38AF              ; last serviced.
2104 38AF              ;
2105 38AF A0 08 00              ldy   #o_RunService            ; fix last serviced field in rec
2106 38B2 A5 05                 lda   TickCount
2107 38B4 97 09                 sta   [PtrToThisOne],y
2108 38B6 C8                    iny   
2109 38B7 C8                    iny   
2110 38B8 A5 07                 lda   TickCount+2
2111 38BA 97 09                 sta   [PtrToThisOne],y
2112 38BC              ;Check signature
2113 38BC A0 06 00              ldy   #o_Signature
2114 38BF B7 09                 lda   [PtrToThisOne],y
2115 38C1 C9 5A A5              cmp   #Signature
2116 38C4 D0 04                 bne   SkipthisOne              ;signature corrupt: skip it
2117 38C6
2118 38C6 22 A2 42 02           jsl   ExecuteRunItem
2119 38CA
2120 38CA A7 09        SkipthisOne lda   [PtrToThisOne]        ; now bump pointer to current da
2121 38CC AA                    tax   
2122 38CD A0 02 00              ldy   #2
2123 38D0 B7 09                 lda   [PtrToThisOne],y
2124 38D2 85 0B                 sta   PtrToThisOne+2
2125 38D4 86 09                 stx   PtrToThisOne
2126 38D6 80 A6                 bra   Loop1
2127 38D8
2128 38D8              AllDone   
2129 38D8 20 55 3A              jsr   UnlockNDAList
2130 38DB 20 D3 3B              jsr   EndNDACall
2131 38DE
2132 38DE 5C 0B 1D 02           jml   oEndCall0
2133 38E2
2134 38E2
2135 38E2                       ENDP 
2136 38E2
2137 38E2
2138 38E2
2139 38E2              ****************************************************************
2140 38E2              *
2141 38E2              * SystemClick
2142 38E2              *
2143 38E2              *              PtrToEvent
2144 38E2              *              PtrToWindow
2145 38E2              *              ResultFromFindWindow
2146 38E2              *              ====================
2147 38E2              *                                   <- SP
2148 38E2              *
2149 38E2              * This is called when an application determines that the mouse
2150 38E2              * went down in a system window.
2151 38E2              *
2152 38E2              * It is the job os SystemClick to
2153 38E2              *
2154 38E2              *      Drag if in DragRegion
2155 38E2              *      TrackGoAway and close if neccessary if in GoAwayBox
2156 38E2              *      TrackZoom and zoom if necessary if in ZoomBox
2157 38E2              *      Grow if in GrowBox
2158 38E2              *      Select if in content and not on top or Pass it on
2159 38E2              *         to the NDA
2160 38E2              *
2161 38E2              * Change History
2162 38E2              *
2163 38E2              * 02 Oct 87             Steven Glass
2164 38E2              *
2165 38E2              * No changes required to support new data structures.  However
2166 38E2              * a couple of changes were made to save code.
2167 38E2              *
2168 38E2              * 15 Mar 89         Steven Glass
2169 38E2              *
2170 38E2              * Added check for click in grow to select window if not front.
2171 38E2              *
2172 38E2              * Use FrontToAX instead of inline FrontWindow calls.
2173 38E2              *
2174 38E2              ****************************************************************
2175 38E2              SystemClick PROC EXPORT 
2176 38E2
2177 38E2                       DSect OrigDirect+2 
2178 38E2              ret1     block 3                        ; equates for zp after StartNDACall
2179 38E2              ret2     block 3 
2180 38E2              FindResult word 
2181 38E2              WindowPtr long 
2182 38E2              EventPtr long 
2183 38E2
2184 38E2              *** added 4-Jul-91 DAL -- call CallDeskAcc in case the NDA wants to handle the click
2185 38E2 48                    pha   
2186 38E3 5A                    phy                            ;save for later
2187 38E4
2188 38E4 A9 00 00              lda   #0
2189 38E7 8F 3A 3E 02           sta   >sysClickBlock
2190 38EB A3 0B                 lda   11,s                     ;FindWindow result
2191 38ED              ;;;	and	#$7fff
2192 38ED 0A                    asl   a
2193 38EE 4A                    lsr   a
2194 38EF 8F 3C 3E 02           sta   >sysClickBlock+2
2195 38F3 A3 0D                 lda   13,s                     ;low word of Window Pointer
2196 38F5 8F 3E 3E 02           sta   >sysClickBlock+4
2197 38F9 A3 0F                 lda   15,s                     ;high word of Window Pointer
2198 38FB 8F 40 3E 02           sta   >sysClickBlock+6
2199 38FF A3 11                 lda   17,s                     ;low word of event pointer
2200 3901 8F 42 3E 02           sta   >sysClickBlock+8
2201 3905 A3 13                 lda   19,s                     ;high word of event pointer
2202 3907 8F 44 3E 02           sta   >sysClickBlock+10
2203 390B
2204 390B F4 00 00              pea   0                        ;space for CallDeskAcc result
2205 390E F4 01 00              pea   $0001                    ;call NDA Action routine by window pointer
2206 3911 A3 13                 lda   15+4,s
2207 3913 48                    pha   
2208 3914 A3 13                 lda   15+4,s
2209 3916 48                    pha                            ;pushed window pointer
2210 3917 F4 0A 00              pea   $000A                    ;action code = handle SystemClick
2211 391A F4 02 00 F4           pushlong #sysClickBlock        ;data value
2212 3920 A2 05 24 22           _CallDeskAcc 
2213 3927 FA                    plx                            ;discard
2214 3928 AF 3A 3E 02           lda   >sysClickBlock
2215 392C F0 18                 beq   sysClickCont             ;nonzero result = handled it
2216 392E
2217 392E 7A                    ply   
2218 392F 68                    pla                            ;discard saved registers
2219 3930
2220 3930 A2 00 00              ldx   #0                       ;no error
2221 3933 A0 0A 00              ldy   #10                      ;strip 10 bytes
2222 3936 5C 84 01 E1           jml   $e10184                  ;ToStrip
2223 393A
2224 393A 00 00        sysClickBlock DC W:0                    ;result
2225 393C 00 00                 DC W:0                         ;FindWindow result (SysClick parm)
2226 393E 00 00 00 00           DC L:0                         ;Window Pointer (SysClick parm)
2227 3942 00 00 00 00           DC L:0                         ;Event Pointer (SysClick parm)
2228 3946
2229 3946 7A           sysClickCont ply   
2230 3947 68                    pla   
2231 3948              *** end of 4-Jul-91 DAL
2232 3948
2233 3948 20 BF 3B              jsr   StartNDACall
2234 394B 20 37 3A              jsr   DerefNDAList
2235 394E
2236 394E A5 21                 lda   FindResult               ; in content
2237 3950              ;;;	and	#$7FFF	; mask off the system window bit
2238 3950              ;;;	sec
2239 3950              ;;;	sbc	#19
2240 3950              ;;;	asl	a
2241 3950              *** opt 2-Jul-92 DAL
2242 3950 0A                    asl   a
2243 3951 38                    sec   
2244 3952 E9 26 00              sbc   #19+19
2245 3955              *** end opt
2246 3955 AA                    tax   
2247 3956 E0 12 00              cpx   #ClickTableEnd-ClickTable
2248 3959 B0 03                 bcs   @ignore
2249 395B FC 68 3E              jsr   (ClickTable,x)
2250 395E              @ignore   
2251 395E 20 55 3A              jsr   UnlockNDAList
2252 3961 20 D3 3B              jsr   EndNdaCall
2253 3964
2254 3964 5C 7B 1D 02           jml   oEndCall10
2255 3968
2256 3968
2257 3968 7A 3E        ClickTable DC W:ClickInContent          ; 19
2258 396A E5 3E                 DC W:ClickInDrag               ; 20
2259 396C 30 3F                 DC W:ClickInGrow               ; 21
2260 396E 96 3F                 DC W:ClickInGoaway             ; 22
2261 3970 BF 3F                 DC W:ClickInZoom               ; 23
2262 3972 7A 3E                 DC W:ClickInInfo               ; 24
2263 3974 7A 3E                 DC W:ClickInVScroll            ; 25
2264 3976 7A 3E                 DC W:ClickInHScroll            ; 26
2265 3978 7A 3E                 DC W:ClickInFrame              ; 27
2266 397A              ClickTableEnd  
2267 397A
2268 397A              ****************************************************************
2269 397A              *
2270 397A              * A click in the content area means one of two things:
2271 397A              *
2272 397A              *      The da is the top window:   Pass click on to NDA
2273 397A              *      da is not the top window:   Select the sucker.
2274 397A              *
2275 397A              ****************************************************************
2276 397A              ClickInContent                          ; 
2277 397A              ClickInInfo                             ; 
2278 397A              ClickInVScroll                          ; 
2279 397A              ClickInHScroll                          ; 
2280 397A              ClickInFrame                            ; 
2281 397A
2282 397A                       import FrontToAX 
2283 397A
2284 397A              ;;;PassItAnyway
2285 397A 20 E2 3B              jsr   FrontToAX
2286 397D
2287 397D C5 23                 cmp   WindowPtr
2288 397F D0 1B                 bne   SelectIt
2289 3981 E4 25                 cpx   WindowPtr+2
2290 3983 D0 17                 bne   SelectIt
2291 3985
2292 3985              ;------------------------------------------------------
2293 3985              ;
2294 3985              ; It is top so send the event on!
2295 3985              ;
2296 3985 20 77 3A              jsr   FindThisWindow
2297 3988 90 11                 bcc   ImConfused
2298 398A
2299 398A 20 21 3B              jsr   SetResID
2300 398D
2301 398D A9 01 00              lda   #DAEventCode
2302 3990 A6 27                 ldx   EventPtr
2303 3992 A4 29                 ldy   EventPtr+2
2304 3994 22 90 3B 02           jsl   SendAction
2305 3998
2306 3998 20 4C 3B              jsr   RepResID
2307 399B
2308 399B 60           ImConfused rts   
2309 399C
2310 399C              SelectIt  
2311 399C              ;	PushLong WindowPtr
2312 399C D4 25                 pei   <WindowPtr+2
2313 399E D4 23                 pei   <WindowPtr
2314 39A0 A2 0E 11 22           _SelectWindow 
2315 39A7
2316 39A7              *** added 21-Apr-91 DAL -- if the window frame qContent bit is set, pass it along to the NDA!
2317 39A7 48                    pha   
2318 39A8 D4 25                 pei   <WindowPtr+2
2319 39AA D4 23                 pei   <WindowPtr
2320 39AC A2 0E 2C 22           _GetWFrame 
2321 39B3 68                    pla   
2322 39B4 29 40 00              and   #$0040                   ;bit 6 = qContent
2323 39B7              ;;;	bne	PassItAnyway
2324 39B7              *** added 4-Dec-91 DAL -- recompute what part of the window it is and make a
2325 39B7              *** tail-recursive call to SystemClick with the new values
2326 39B7 F0 2B                 beq   @ignoreIt
2327 39B9 D4 29                 pei   <EventPtr+2
2328 39BB D4 27                 pei   <EventPtr
2329 39BD D4 25                 pei   <WindowPtr+2
2330 39BF D4 23                 pei   <WindowPtr
2331 39C1 48                    pha                            ;space for FindWindow
2332 39C2 F4 00 00              pea   0
2333 39C5 7B                    tdc   
2334 39C6 18                    clc   
2335 39C7 69 23 00              adc   #WindowPtr               ;new value not used (we assume it's the same)
2336 39CA 48                    pha   
2337 39CB A0 0C 00              ldy   #12                      ;event.where.x
2338 39CE B7 27                 lda   [<EventPtr],y
2339 39D0 48                    pha                            ;X value for FindWindow
2340 39D1 88                    dey   
2341 39D2 88                    dey   
2342 39D3 B7 27                 lda   [<EventPtr],y
2343 39D5 48                    pha                            ;Y value for FindWindow
2344 39D6 A2 0E 17 22           _FindWindow 
2345 39DD A2 05 17 22           _SystemClick 
2346 39E4              @ignoreIt  
2347 39E4              *** end 4-Dec-91 DAL
2348 39E4              *** end of 21-Apr-91 DAL
2349 39E4
2350 39E4 60                    rts   
2351 39E5
2352 39E5
2353 39E5 A0 0E 00     ClickInDrag ldy   #o_modifiers          ; if this is shift click
2354 39E8 B7 27                 lda   [EventPtr],y             ; then drag in current plain
2355 39EA 29 00 01              and   #m_AppleKey              ; else bring to top then drag
2356 39ED D0 0E                 bne   SkipSelect
2357 39EF
2358 39EF              ;------------------------------------------------------
2359 39EF              ;
2360 39EF              ; First see if we are the top window
2361 39EF              ;
2362 39EF 20 E2 3B              jsr   FrontToAX
2363 39F2
2364 39F2 C5 23                 cmp   WindowPtr
2365 39F4 D0 04                 bne   MustSelect
2366 39F6 E4 25                 cpx   WindowPtr+2
2367 39F8 F0 03                 beq   SkipSelect
2368 39FA
2369 39FA 20 9C 3E     MustSelect jsr   SelectIt
2370 39FD
2371 39FD
2372 39FD              SkipSelect  
2373 39FD              ;
2374 39FD              ; 3/16/89           Mensch
2375 39FD              ; Added call to stilldown to be sure that the mouse button state hasn't
2376 39FD              ; changed during the select.
2377 39FD
2378 39FD 48                    pha                            ; room for result
2379 39FE F4 00 00              pea   00                       ; button number
2380 3A01 A2 06 0E 22           _StillDown                     ; test for it to still be down
2381 3A08 68                    pla   
2382 3A09 F0 24                 beq   @Done                    ; if not still down, then just leave...
2383 3A0B              ;
2384 3A0B              ; Done with change
2385 3A0B F4 00 00              PushWord #0                    ; default grid
2386 3A0E A0 0C 00              ldy   #o_Where+2               ; where
2387 3A11 B7 27                 lda   [EventPtr],y
2388 3A13 48                    pha   
2389 3A14 88                    dey   
2390 3A15 88                    dey   
2391 3A16 B7 27                 lda   [EventPtr],y
2392 3A18 48                    pha   
2393 3A19 F4 08 00              PushWord #8                    ; grace
2394 3A1C F4 00 00 F4           PushLong #0                    ; bounds rect (default)
2395 3A22 A5 25 48 A5           PushLong WindowPtr 
2396 3A28 A2 0E 1A 22           _DragWindow 
2397 3A2F              @Done     
2398 3A2F 60                    rts   
2399 3A30
2400 3A30              ClickInGrow  
2401 3A30 20 E2 3B              jsr   FrontToAX
2402 3A33 C5 23                 cmp   WindowPtr
2403 3A35 D0 2F                 bne   toSelectIt
2404 3A37 E4 25                 cpx   WindowPtr+2
2405 3A39 D0 2B                 bne   toSelectIt
2406 3A3B
2407 3A3B 48                    pha                            ; space for result
2408 3A3C 48                    pha   
2409 3A3D
2410 3A3D 20 69 3F              jsr   PushMinSize              ;DAL 4-Mar-91
2411 3A40              ***	PushWord #20		; min x
2412 3A40              ***	PushWord #10		; min y
2413 3A40 A0 0C 00              ldy   #o_Where+2               ; where x
2414 3A43 B7 27                 lda   [EventPtr],y
2415 3A45 48                    pha   
2416 3A46 88                    dey   
2417 3A47 88                    dey   
2418 3A48 B7 27                 lda   [EventPtr],y             ; where y
2419 3A4A 48                    pha   
2420 3A4B A5 25 48 A5           PushLong WindowPtr             ; pointer to window
2421 3A51 A2 0E 1B 22           _GrowWindow 
2422 3A58
2423 3A58 A5 25 48 A5           PushLong WindowPtr             ; don't forget to set the final size
2424 3A5E A2 0E 1C 22           _SizeWindow 
2425 3A65
2426 3A65 60                    rts   
2427 3A66
2428 3A66 82 33 FF     toSelectIt brl   SelectIt               ;added 4-Dec-91 DAL
2429 3A69
2430 3A69              *
2431 3A69              * PushMinSize -- push 20,10 or the min size from the AuxWindInfo (4-Mar-91 DAL)
2432 3A69              *
2433 3A69 48           PushMinSize pha   
2434 3A6A 48                    pha   
2435 3A6B A5 25 48 A5           pushlong WindowPtr 
2436 3A71 A2 0E 63 22           _GetAuxWindInfo 
2437 3A78 0B                    phd   
2438 3A79 3B                    tsc   
2439 3A7A 5B                    tcd   
2440 3A7B A0 14 00              ldy   #20                      ;offset to min height
2441 3A7E B7 03                 lda   [3],y
2442 3A80 AA                    tax   
2443 3A81 C8                    iny   
2444 3A82 C8                    iny   
2445 3A83 B7 03                 lda   [3],y                    ;min width
2446 3A85 2B                    pld   
2447 3A86 7A                    ply   
2448 3A87 7A                    ply                            ;min height/width in XA
2449 3A88 9B                    txy                            ;zero?
2450 3A89 D0 06                 bne   @nonzero
2451 3A8B              ;;;	ldx	#10	;old default height
2452 3A8B              ;;;	lda	#20	;old default width
2453 3A8B A2 22 00              ldx   #34                      ;min height (9-Nov-91 DAL)
2454 3A8E A9 4E 00              lda   #78                      ;min width (9-Nov-91 DAL)
2455 3A91 7A           @nonzero ply                            ;pull return address
2456 3A92 48                    pha   
2457 3A93 DA                    phx   
2458 3A94 5A                    phy   
2459 3A95 60                    rts   
2460 3A96
2461 3A96
2462 3A96 48           ClickInGoAway pha                       ; space for result
2463 3A97 A0 0C 00              ldy   #o_Where+2               ; where x
2464 3A9A B7 27                 lda   [EventPtr],y
2465 3A9C 48                    pha   
2466 3A9D 88                    dey   
2467 3A9E 88                    dey   
2468 3A9F B7 27                 lda   [EventPtr],y             ; where y
2469 3AA1 48                    pha   
2470 3AA2 A5 25 48 A5           PushLong WindowPtr             ; pointer to window
2471 3AA8 A2 0E 18 22           _TrackGoaway 
2472 3AAF
2473 3AAF 68                    pla   
2474 3AB0 F0 0C                 beq   DontClose
2475 3AB2
2476 3AB2
2477 3AB2 A5 23                 lda   WindowPtr
2478 3AB4 A6 25                 ldx   WindowPtr+2
2479 3AB6 20 77 3A              jsr   FindThisWindow
2480 3AB9 90 03                 bcc   DontClose
2481 3ABB
2482 3ABB 20 A4 3C              jsr   DoCloseStuff
2483 3ABE
2484 3ABE 60           DontClose rts   
2485 3ABF
2486 3ABF
2487 3ABF
2488 3ABF F4 00 00     ClickInZoom PushWord #0 
2489 3AC2 A0 0C 00              ldy   #o_Where+2               ; where x
2490 3AC5 B7 27                 lda   [EventPtr],y
2491 3AC7 48                    pha   
2492 3AC8 88                    dey   
2493 3AC9 88                    dey   
2494 3ACA B7 27                 lda   [EventPtr],y             ; where y
2495 3ACC 48                    pha   
2496 3ACD A5 25 48 A5           PushLong WindowPtr             ; pointer to window
2497 3AD3 A2 0E 26 22           _TrackZoom 
2498 3ADA
2499 3ADA 68                    pla   
2500 3ADB F0 0D                 beq   DontZoom
2501 3ADD
2502 3ADD A5 25 48 A5           PushLong WindowPtr 
2503 3AE3 A2 0E 27 22           _ZoomWindow 
2504 3AEA
2505 3AEA 60           DontZoom rts   
2506 3AEB
2507 3AEB
2508 3AEB                       ENDP 
2509 3AEB
2510 3AEB
2511 3AEB
2512 3AEB
2513 3AEB              ****************************************************************
2514 3AEB              *
2515 3AEB              * SystemEdit
2516 3AEB              *
2517 3AEB              *        Space for boolean result
2518 3AEB              *        Edit Code
2519 3AEB              *        ------------------------
2520 3AEB              *                                   <-SP
2521 3AEB              *
2522 3AEB              * The application calls this when the user selects cut, copy
2523 3AEB              * paste, undo or clear from the edit menu.  The
2524 3AEB              * user passes the edit code on the stack.
2525 3AEB              *
2526 3AEB              * NDA returns boolean in a register.  True if action is
2527 3AEB              * taken, false otherwise.
2528 3AEB              *
2529 3AEB              * The Edit codes are
2530 3AEB              *
2531 3AEB              *                  Action code send     Code sent to System Edit
2532 3AEB              *                  to NDA               by application
2533 3AEB              *      Undo           5                        1
2534 3AEB              *      Cut            6                        2
2535 3AEB              *      Copy           7                        3
2536 3AEB              *      Paste          8                        4
2537 3AEB              *      Clear          9                        5
2538 3AEB              *
2539 3AEB              * Change History
2540 3AEB              *
2541 3AEB              * 02 Oct 87             Steven Glass
2542 3AEB              *
2543 3AEB              * No changes required to support new data structures.  However
2544 3AEB              * a couple of changes were made to save code.
2545 3AEB              *
2546 3AEB              * 19 Apr 89         Steven Glass
2547 3AEB              *
2548 3AEB              * Fixed bug where return code from DA was trashed while 
2549 3AEB              * restoring the resource manager's user id.
2550 3AEB              *
2551 3AEB              ****************************************************************
2552 3AEB              SystemEdit PROC EXPORT 
2553 3AEB
2554 3AEB
2555 3AEB                       import FrontToAX 
2556 3AEB
2557 3AEB
2558 3AEB                       DSect OrigDirect+2 
2559 3AEB              RTL1     block 3 
2560 3AEB              RTL2     block 3 
2561 3AEB              EditID   word 
2562 3AEB              Result   word 
2563 3AEB
2564 3AEB 20 BF 3B              jsr   StartNDACall
2565 3AEE 20 37 3A              jsr   DerefNDAList
2566 3AF1
2567 3AF1 64 23                 stz   Result                   ; start by assuming no!  added 19 Apr 89 SEG
2568 3AF3
2569 3AF3 20 E2 3B              jsr   FrontToAX
2570 3AF6
2571 3AF6 20 77 3A              jsr   FindThisWindow
2572 3AF9 90 12                 bcc   NotOurs
2573 3AFB
2574 3AFB 20 21 3B              jsr   SetResID
2575 3AFE
2576 3AFE A5 21                 lda   EditID                   ; add the edit id number to
2577 3B00 18                    clc                            ; undo code to get right code
2578 3B01 69 04 00              adc   #DAUndoCode-1
2579 3B04 22 90 3B 02           jsl   SendAction               ; return result in a-reg
2580 3B08 85 23                 sta   Result                   ; Save it now!  added 19 Apr 89 SEG
2581 3B0A 20 4C 3B              jsr   RepResID
2582 3B0D
2583 3B0D              NotOurs   
2584 3B0D 20 55 3A              jsr   UnlockNDAList
2585 3B10 20 D3 3B              jsr   EndNDACall
2586 3B13
2587 3B13 5C 23 1D 02           jml   oEndCall2
2588 3B17
2589 3B17                       ENDP 
2590 3B17
2591 3B17
2592 3B17              DieHorribly PROC EXPORT 
2593 3B17 C2 30                 rep   #$30
2594 3B19 A9 12 05              lda   #BadNDA
2595 3B1C 29 FF 00              and   #$00FF
2596 3B1F 09 00 05              ora   #$0500
2597 3B22 48                    pha   
2598 3B23 F4 00 00 F4           PushLong #0 
2599 3B29 A2 03 15 22           _SysFailMgr 
2600 3B30
2601 3B30                       EndP 
2602 3B30
2603 3B30              ****************************************************************
2604 3B30              *
2605 3B30              * FixAppleMenu2
2606 3B30              *
2607 3B30              *      input     ID of menu to add to
2608 3B30              *
2609 3B30              *      output    none
2610 3B30              *
2611 3B30              * This is called fix apple menu but, it can fix any menu
2612 3B30              * whose id is passed.
2613 3B30              *
2614 3B30              * Change History
2615 3B30              *
2616 3B30              * 02 Oct 87         Steven Glass
2617 3B30              *
2618 3B30              * Changes were needed here to use the new structure of the 
2619 3B30              * NDAGlobals record.
2620 3B30              *
2621 3B30              * Additionally, I changed the code to use the stack to hold a counter
2622 3B30              * instead of storage in line.
2623 3B30              *
2624 3B30              * 12 Oct 87         Steven Glass
2625 3B30              *
2626 3B30              * If an error occurs in parsing the menu data, we branch to
2627 3B30              * die in where the process mode bits are cleared.
2628 3B30              *
2629 3B30              * 20-Nov-90         Dave Lyons
2630 3B30              *
2631 3B30              * Add sorting option.
2632 3B30              *
2633 3B30              ****************************************************************
2634 3B30              FixAppleMenu2 PROC EXPORT 
2635 3B30                       import DieHorribly 
2636 3B30
2637 3B30                       DSect OrigDirect+2
2638 3B30              RTL1     block 3
2639 3B30              RTL2     block 3
2640 3B30              WhichMenu word 
2641 3B30
2642 3B30              *** added 16-Sep-91 DAL
2643 3B30              ***
2644 3B30              *** If the Desk Manager is not yet started, try to start it up.  This
2645 3B30              *** can happen if the application called DeskStartUp too early, so it
2646 3B30              *** did not start up then. -- If we *still* can't start up, then let's
2647 3B30              *** don't add any NDA items to the Apple menu.
2648 3B30              ***
2649 3B30 48                    pha   
2650 3B31 5A                    phy                            ;preserve WAP
2651 3B32
2652 3B32 AF BE 1D E0           lda   >RealDeskStatus
2653 3B36 D0 19                 bne   @weAreStarted
2654 3B38
2655 3B38 A2 05 02 22           _DeskStartUp 
2656 3B3F AF BE 1D E0           lda   >RealDeskStatus
2657 3B43 D0 0C                 bne   @weAreStarted
2658 3B45
2659 3B45 7A                    ply   
2660 3B46 68                    pla                            ;discard original WAP
2661 3B47
2662 3B47 A2 00 00              ldx   #0                       ;no error
2663 3B4A A0 02 00              ldy   #2                       ;strip 2 bytes
2664 3B4D 5C 84 01 E1           jml   $e10184                  ;ToStrip
2665 3B51
2666 3B51 7A           @weAreStarted ply                       ;restore WAP
2667 3B52 68                    pla   
2668 3B53              *** end 16-Sep-91 DAL
2669 3B53
2670 3B53 20 BF 3B              jsr   StartNDACall
2671 3B56 20 37 3A              jsr   DerefNDAList
2672 3B59
2673 3B59 20 80 42              jsr   VerifyBRAM
2674 3B5C
2675 3B5C A7 01                 lda   [NDAListPtr]
2676 3B5E F0 03                 beq   @1
2677 3B60 20 30 41              jsr   NDASurrogateSort         ;added 20-Nov-90 DAL
2678 3B63              @1        
2679 3B63 F4 00 00              PushWord #0                    ; init counter on stack
2680 3B66
2681 3B66 A3 01        InstallLoop lda   1,s
2682 3B68 C7 01                 cmp   [NDAListPtr]
2683 3B6A 90 03                 bcc   Continue
2684 3B6C 82 56 00              brl   AllDone
2685 3B6F
2686 3B6F 20 51 42     Continue jsr   SurrogateLookup          ;DAL
2687 3B72 20 08 41              jsr   PointAtNDA               ;DAL
2688 3B75 20 EB 40              jsr   DerefThisNDAHandle       ;made subroutine 20-Nov-90 DAL
2689 3B78
2690 3B78              ;
2691 3B78              ; Now I have to find the H (or h) that appears after
2692 3B78              ; the back slash.
2693 3B78              ;
2694 3B78 E2 20                 sep   #%00100000               ; switch to 8 bit a reg
2695 3B7A                       longa off
2696 3B7A
2697 3B7A A0 01 00              ldy   #1                       ; start with first char
2698 3B7D B7 11        @SlashLoop lda   [NDAPtr],y
2699 3B7F C9 5C                 cmp   #'\'
2700 3B81 F0 09                 beq   @FoundSlash
2701 3B83 C8                    iny   
2702 3B84 C0 FF 00              cpy   #255
2703 3B87 90 F4                 bcc   @SlashLoop
2704 3B89
2705 3B89 82 8B FF              brl   DieHorribly              ; die horribly if the da is bad
2706 3B8C
2707 3B8C C8           @FoundSlash iny   
2708 3B8D B7 11        @HLoop   lda   [NDAPtr],y
2709 3B8F C9 48                 cmp   #'H'
2710 3B91 F0 0D                 beq   FoundH
2711 3B93 C9 68                 cmp   #'h'
2712 3B95 F0 09                 beq   FoundH
2713 3B97 C8                    iny   
2714 3B98 C0 FF 00              cpy   #255
2715 3B9B 90 F0                 bcc   @HLoop
2716 3B9D
2717 3B9D 82 77 FF              brl   DieHorribly              ; die horribly if the DA is bad
2718 3BA0
2719 3BA0 C2 20        FoundH   rep   #%00100000
2720 3BA2                       longa on
2721 3BA2 C8                    iny                            ; put id number into string
2722 3BA3 A3 01                 lda   1,s                      ; right after H
2723 3BA5
2724 3BA5 5A                    phy   
2725 3BA6 20 51 42              jsr   surrogateLookup 
2726 3BA9 7A                    ply   
2727 3BAA
2728 3BAA 1A                    inc   a
2729 3BAB 97 11                 sta   [NDAPtr],y
2730 3BAD
2731 3BAD A5 13 48 A5           PushLong NDAPtr 
2732 3BB3 F4 FF FF              PushWord #$FFFF 
2733 3BB6 A5 21 48              PushWord WhichMenu 
2734 3BB9 A2 0F 0F 22           _InsertMItem 
2735 3BC0
2736 3BC0 68                    pla   
2737 3BC1 1A                    inc   a
2738 3BC2 48                    pha   
2739 3BC3 80 A1                 bra   InstallLoop
2740 3BC5
2741 3BC5 68           AllDone  pla                            ; clean up stack
2742 3BC6
2743 3BC6 A7 01                 lda   [NDAListPtr]
2744 3BC8 F0 03                 beq   @1
2745 3BCA 20 66 42              jsr   SurrogateDispose         ;DAL 20-Nov-90
2746 3BCD              @1        
2747 3BCD
2748 3BCD 20 55 3A              jsr   UnlockNDAList
2749 3BD0
2750 3BD0              *** added 24-Jul-91 DAL -- call SendRequest(systemSaysFixedAppleMenu)
2751 3BD0 F4 1E 05              pea   $051E                    ;systemSaysFixedAppleMenu
2752 3BD3 A2 00 00              ldx   #0
2753 3BD6 DA                    phx                            ;sendHow
2754 3BD7 DA                    phx   
2755 3BD8 DA                    phx                            ;target = nil
2756 3BD9 DA                    phx   
2757 3BDA DA                    phx                            ;dataIn = nil
2758 3BDB DA                    phx   
2759 3BDC DA                    phx                            ;dataOut = nil
2760 3BDD A2 01 1C 22           _SendRequest 
2761 3BE4              *** end 24-Jul-91 DAL
2762 3BE4
2763 3BE4 20 D3 3B              jsr   ENDNDACall
2764 3BE7 5C 23 1D 02           jml   oEndCall2
2765 3BEB
2766 3BEB              ************************************************************
2767 3BEB              *
2768 3BEB              * Made this into a subroutine, 20-Nov-90 DAL
2769 3BEB              *
2770 3BEB              * Input:  PtrToThisOne
2771 3BEB              * Output: NDAPtr (points to menu line for NDA)
2772 3BEB              *
2773 3BEB              DerefThisNDAHandle  
2774 3BEB A0 1E 00              ldy   #o_handle
2775 3BEE B7 09                 lda   [PtrToThisOne],y
2776 3BF0 85 0D                 sta   NDAhandle
2777 3BF2 C8                    iny   
2778 3BF3 C8                    iny   
2779 3BF4 B7 09                 lda   [PtrToThisOne],y
2780 3BF6 85 0F                 sta   NDAHandle+2
2781 3BF8
2782 3BF8 20 6B 3A              jsr   DerefNDAHandle
2783 3BFB
2784 3BFB A5 11                 lda   NDAPtr
2785 3BFD 18                    clc   
2786 3BFE 69 14 00              adc   #20
2787 3C01 85 11                 sta   NDAPtr
2788 3C03 90 02                 bcc   @NoCarryToLine
2789 3C05 E6 13                 inc   NDAPtr+2
2790 3C07 60           @NoCarryToLine rts   
2791 3C08
2792 3C08
2793 3C08              **********************************************************************
2794 3C08              *
2795 3C08              * PointAtNDA (20-Nov-90 DAL)
2796 3C08              *
2797 3C08              * Input:  A = NDA number (0..NumNDAs-1)
2798 3C08              *
2799 3C08              * Output:  PtrToThisOne points to our data for this DA
2800 3C08              *
2801 3C08 48           PointAtNDA pha   
2802 3C09 48                    pha                            ;long space for _Multiply result
2803 3C0A 48                    pha                            ;input to _Multiply
2804 3C0B F4 24 00              pea   NDARecSize
2805 3C0E A2 0B 09 22           _Multiply 
2806 3C15
2807 3C15 A5 01                 lda   NDAListPtr
2808 3C17 18                    clc   
2809 3C18 69 0E 00              adc   #SizeOfDeskGlobals
2810 3C1B 85 09                 sta   PtrToThisOne
2811 3C1D A5 03                 lda   NDAListPtr+2
2812 3C1F 90 01                 bcc   @NoCarry1
2813 3C21 1A                    inc   a
2814 3C22 85 0B        @NoCarry1 sta   PtrToThisOne+2
2815 3C24
2816 3C24 68                    pla                            ;add on the result of the _Multiply
2817 3C25 18                    clc   
2818 3C26 65 09                 adc   PtrToThisOne
2819 3C28 85 09                 sta   PtrToThisOne
2820 3C2A 68                    pla   
2821 3C2B 65 0B                 adc   PtrToThisOne+2
2822 3C2D 85 0B                 sta   PtrToThisOne+2
2823 3C2F
2824 3C2F 60                    rts   
2825 3C30
2826 3C30
2827 3C30              **********************************************************************
2828 3C30              *
2829 3C30              * NDASurrogateSort
2830 3C30              * 20-Nov-90 DAL
2831 3C30              *
2832 3C30              * Allocates
2833 3C30              *
2834 3C30 48           NDASurrogateSort pha   
2835 3C31 48                    pha                            ;space for NewHandle
2836 3C32 F4 00 00              pea   0                        ;size high
2837 3C35 A7 01                 lda   [<NDAListPtr]            ;number of NDAs
2838 3C37 0A                    asl   a                        ;  times 2
2839 3C38 48                    pha                            ;size low
2840 3C39 F4 01 50              pea   $5001                    ;id
2841 3C3C F4 00 80              pea   $8000                    ;attributes
2842 3C3F 48                    pha   
2843 3C40 48                    pha   
2844 3C41 A2 02 09 22           _NewHandle 
2845 3C48 0B                    phd   
2846 3C49 3B                    tsc   
2847 3C4A 5B                    tcd   
2848 3C4B A0 02 00              ldy   #2
2849 3C4E B7 03                 lda   [3],y
2850 3C50 8F 7E 42 02           sta   >SurrogatePtr+2
2851 3C54 A7 03                 lda   [3]
2852 3C56 8F 7C 42 02           sta   >SurrogatePtr
2853 3C5A 2B                    pld   
2854 3C5B 68                    pla   
2855 3C5C 8F 78 42 02           sta   >SurrogateHandle
2856 3C60 68                    pla   
2857 3C61 8F 7A 42 02           sta   >SurrogateHandle+2
2858 3C65
2859 3C65              *** Initialize the surrogate array to linear list:  a[n]=n
2860 3C65
2861 3C65 A7 01                 lda   [<NDAListPtr]            ;number of NDAs
2862 3C67 3A                    dec   a                        ;minus one
2863 3C68 AA                    tax   
2864 3C69
2865 3C69 0B                    phd   
2866 3C6A AF 7E 42 02           pushlong >SurrogatePtr 
2867 3C74 3B                    tsc   
2868 3C75 5B                    tcd   
2869 3C76 8A                    txa   
2870 3C77 0A                    asl   a
2871 3C78 A8                    tay   
2872 3C79 8A                    txa   
2873 3C7A 97 01        @init    sta   [1],y
2874 3C7C 88                    dey   
2875 3C7D 88                    dey   
2876 3C7E 3A                    dec   a
2877 3C7F 10 F9                 bpl   @init
2878 3C81 7A                    ply   
2879 3C82 7A                    ply   
2880 3C83 2B                    pld   
2881 3C84
2882 3C84 48                    pha                            ;space for result
2883 3C85 F4 5F 00              pea   $5f                      ;toolbox misc parameter
2884 3C88 A2 03 0C 22           _ReadBParam 
2885 3C8F 68                    pla   
2886 3C90 4A                    lsr   a
2887 3C91 90 2A                 bcc   @noSortDA                ;bit 0 clear = don't sort
2888 3C93
2889 3C93              *** do the sort
2890 3C93 8B                    phb   
2891 3C94 4B                    phk   
2892 3C95 AB                    plb   
2893 3C96
2894 3C96 A7 01                 lda   [<NDAListPtr]
2895 3C98 3A                    dec   a
2896 3C99 F0 21                 beq   @sorted
2897 3C9B 9C BE 41     @OutBubble stz   sortIndex
2898 3C9E 9C C0 41              stz   swappedFlag
2899 3CA1 20 C2 41     @InBubble jsr   compareTwo
2900 3CA4 90 06                 bcc   @ordered
2901 3CA6 6E C0 41              ror   swappedFlag
2902 3CA9 20 2D 42              jsr   swapTwo
2903 3CAC EE BE 41     @ordered inc   sortIndex
2904 3CAF AD BE 41              lda   sortIndex
2905 3CB2 1A                    inc   a
2906 3CB3 C7 01                 cmp   [<NDAListPtr]
2907 3CB5 90 EA                 bcc   @InBubble
2908 3CB7 AD C0 41              lda   swappedFlag
2909 3CBA D0 DF                 bne   @OutBubble
2910 3CBC
2911 3CBC AB           @sorted  plb   
2912 3CBD
2913 3CBD 60           @noSortDA rts   
2914 3CBE
2915 3CBE 00 00        sortIndex DC W:0
2916 3CC0 00 00        swappedFlag DC W:0
2917 3CC2
2918 3CC2
2919 3CC2              **********************************************************************
2920 3CC2              *
2921 3CC2              * compareTwo
2922 3CC2              *
2923 3CC2              * Compare the sortIndex-th NDA name with the (sortIndex+1)th NDA
2924 3CC2              * name.  Return CLC if they are already properly ordred.
2925 3CC2              *
2926 3CC2 0B           compareTwo phd   
2927 3CC3
2928 3CC3 AD BE 41              lda   sortIndex
2929 3CC6 1A                    inc   a
2930 3CC7 20 0F 42              jsr   GetNamePointer           ;into XA
2931 3CCA DA                    phx   
2932 3CCB 48                    pha   
2933 3CCC
2934 3CCC AD BE 41              lda   sortIndex
2935 3CCF 20 0F 42              jsr   GetNamePointer           ;into XA
2936 3CD2 DA                    phx   
2937 3CD3 48                    pha   
2938 3CD4
2939 3CD4 3B                    tsc   
2940 3CD5 5B                    tcd   
2941 3CD6
2942 3CD6              ** compare "\"-terminated string at [1] string at [5]
2943 3CD6
2944 3CD6 E2 30                 sep   #$30
2945 3CD8                       longa off
2946 3CD8                       longi off
2947 3CD8
2948 3CD8 A0 00                 ldy   #0
2949 3CDA B7 01        @compare lda   [1],y
2950 3CDC C9 5C                 cmp   #'\'                     ;moved from below 30-Nov-90 DAL (to not hang with identical names)
2951 3CDE F0 18                 beq   @lesser                  ;moved from below 30-Nov-90 DAL
2952 3CE0 B7 05                 lda   [5],y
2953 3CE2 C9 5C                 cmp   #'\'
2954 3CE4 F0 15                 beq   @greater
2955 3CE6 20 04 42              jsr   upcase
2956 3CE9 8D F2 41              sta   @cheat+1
2957 3CEC B7 01                 lda   [1],y
2958 3CEE              ;;;;	cmp	#'\'	;moved above 30-Nov-90 DAL
2959 3CEE              ;;;;	beq	@lesser	;moved above 30-Nov-90 DAL
2960 3CEE 20 04 42              jsr   upcase
2961 3CF1 C9 77        @cheat   cmp   #$77
2962 3CF3 D0 07                 bne   @done
2963 3CF5 C8                    iny   
2964 3CF6 80 E2                 bra   @compare
2965 3CF8
2966 3CF8 18           @lesser  clc   
2967 3CF9 80 01                 bra   @done
2968 3CFB 38           @greater sec   
2969 3CFC C2 30        @done    rep   #$30
2970 3CFE                       longa on
2971 3CFE                       longi on
2972 3CFE
2973 3CFE 7A                    ply   
2974 3CFF 7A                    ply   
2975 3D00 7A                    ply   
2976 3D01 7A                    ply   
2977 3D02 2B                    pld   
2978 3D03 60                    rts   
2979 3D04
2980 3D04
2981 3D04              **********************************************************************
2982 3D04              *
2983 3D04              * upcase
2984 3D04              *
2985 3D04                       longa off
2986 3D04 C9 61        upcase   cmp   #'a'
2987 3D06 90 06                 bcc   @1
2988 3D08 C9 7B                 cmp   #'z'+1
2989 3D0A B0 02                 bcs   @1
2990 3D0C 29 DF                 and   #$DF
2991 3D0E 60           @1       rts   
2992 3D0F                       longa on
2993 3D0F
2994 3D0F
2995 3D0F              **********************************************************************
2996 3D0F              *
2997 3D0F              * GetNamePointer
2998 3D0F              *
2999 3D0F              * Input:  A,  D=desk manager stuff
3000 3D0F              *
3001 3D0F              * Output: XA = pointer to NDA's PString name
3002 3D0F              *
3003 3D0F 20 51 42     GetNamePointer jsr   SurrogateLookup
3004 3D12 20 08 41              jsr   PointAtNDA
3005 3D15 20 EB 40              jsr   DerefThisNDAHandle
3006 3D18
3007 3D18              * skip past two boring leading bytes plus any leading blanks
3008 3D18 A0 01 00              ldy   #1
3009 3D1B C8           @skipblanks iny   
3010 3D1C B7 11                 lda   [<NDAPtr],y
3011 3D1E 29 FF 00              and   #$00ff
3012 3D21 C9 20 00              cmp   #$0020
3013 3D24 F0 F5                 beq   @skipblanks
3014 3D26 18                    clc   
3015 3D27 98                    tya   
3016 3D28 65 11                 adc   NDAPtr
3017 3D2A A6 13                 ldx   NDAPtr+2
3018 3D2C 60                    rts   
3019 3D2D
3020 3D2D              **********************************************************************
3021 3D2D              *
3022 3D2D              * swapTwo
3023 3D2D              *
3024 3D2D              * Swaps the sortIndex-th and (sortIndex+1)th surrogate entries.
3025 3D2D              *
3026 3D2D              * Inputs:  SurrogatePtr, sortIndex.
3027 3D2D              *
3028 3D2D              * The bank register must be set.
3029 3D2D              * Trashes Y.
3030 3D2D              *
3031 3D2D AD BE 41     swapTwo  lda   sortIndex
3032 3D30 0A                    asl   a
3033 3D31 A8                    tay   
3034 3D32 0B                    phd   
3035 3D33 AD 7E 42              lda   SurrogatePtr+2
3036 3D36 48                    pha   
3037 3D37 AD 7C 42              lda   SurrogatePtr
3038 3D3A 48                    pha   
3039 3D3B 3B                    tsc   
3040 3D3C 5B                    tcd   
3041 3D3D B7 01                 lda   [1],y
3042 3D3F 48                    pha                            ;save first value
3043 3D40 C8                    iny   
3044 3D41 C8                    iny   
3045 3D42 B7 01                 lda   [1],y                    ;get 2nd value
3046 3D44 88                    dey   
3047 3D45 88                    dey   
3048 3D46 97 01                 sta   [1],y                    ;put it in first location
3049 3D48 C8                    iny   
3050 3D49 C8                    iny   
3051 3D4A 68                    pla                            ;put old first value into 2nd location
3052 3D4B 97 01                 sta   [1],y
3053 3D4D 7A                    ply   
3054 3D4E 7A                    ply   
3055 3D4F 2B                    pld   
3056 3D50 60                    rts   
3057 3D51
3058 3D51              *
3059 3D51              * SurrogateLookup
3060 3D51              * 20-Nov-90 DAL
3061 3D51              *
3062 3D51              * Input:  A = position in surrogate-sort array
3063 3D51              * Output: A = NDA number
3064 3D51              *
3065 3D51              * Looks up an NDA number from a position index
3066 3D51              *
3067 3D51              * Trashes Y.
3068 3D51              *
3069 3D51 0A           SurrogateLookup asl   a
3070 3D52 A8                    tay   
3071 3D53 0B                    phd   
3072 3D54 AF 7E 42 02           lda   >SurrogatePtr+2
3073 3D58 48                    pha   
3074 3D59 AF 7C 42 02           lda   >SurrogatePtr
3075 3D5D 48                    pha   
3076 3D5E 3B                    tsc   
3077 3D5F 5B                    tcd   
3078 3D60 B7 01                 lda   [1],y
3079 3D62 7A                    ply   
3080 3D63 7A                    ply   
3081 3D64 2B                    pld   
3082 3D65 60                    rts   
3083 3D66              *
3084 3D66              * SurrogateDispose
3085 3D66              * 20-Nov-90 DAL
3086 3D66              *
3087 3D66 AF 7A 42 02  SurrogateDispose pushlong >SurrogateHandle 
3088 3D70 A2 02 10 22           _DisposeHandle 
3089 3D77 60                    rts   
3090 3D78
3091 3D78 00 00 00 00  SurrogateHandle DC L:0
3092 3D7C 00 00 00 00  SurrogatePtr DC L:0
3093 3D80
3094 3D80
3095 3D80              *
3096 3D80              * VerifyBRAM -- if the toolbox misc location isn't initialized,
3097 3D80              *               give it a nice default value.
3098 3D80              *
3099 3D80              * We have to do this because it defaults to 0 on ROM 1 and
3100 3D80              * $ff on ROM 3.
3101 3D80              *
3102 3D80                       entry VerifyBRAM
3103 3D80 48           VerifyBRAM pha   
3104 3D81 F4 5F 00              pea   $5f
3105 3D84 A2 03 0C 22           _ReadBParam 
3106 3D8B 68                    pla   
3107 3D8C 29 C0 00              and   #%11000000
3108 3D8F C9 80 00              cmp   #%10000000
3109 3D92 F0 0D                 beq   @okay
3110 3D94 F4 81 00              pea   $81                      ;Initialize toolbox location to default value ($81)
3111 3D97 F4 5F 00              pea   $5F
3112 3D9A A2 03 0B 22           _WriteBParam 
3113 3DA1 60           @okay    rts   
3114 3DA2
3115 3DA2
3116 3DA2                       ENDP 
3117 3DA2
3118 3DA2
3119 3DA2              ****************************************************************
3120 3DA2              *
3121 3DA2              * ExecuteRunItem
3122 3DA2              *
3123 3DA2              * Inputs
3124 3DA2              *    PointerToThisOne
3125 3DA2              *
3126 3DA2              * Output
3127 3DA2              *    Depends on RunQ item
3128 3DA2              *
3129 3DA2              * This routine transfers control to PointerToThisOne + RunEntry.
3130 3DA2              * All registers and relative stack locations are preserved.
3131 3DA2              * Control returns from the run item to the Calling routine, not here.
3132 3DA2              *
3133 3DA2              *
3134 3DA2              * Added by:
3135 3DA2              *
3136 3DA2              * Konstantin Othmer                     02 Oct 88
3137 3DA2              *
3138 3DA2              ****************************************************************
3139 3DA2              ExecuteRunItem PROC EXPORT 
3140 3DA2
3141 3DA2              s_YReg   equ   1
3142 3DA2              s_AReg   equ   3
3143 3DA2              s_AdrForAction equ   5                  ;stack + 5 has low byte
3144 3DA2
3145 3DA2 48                    pha                            ; put 3 bytes on stack
3146 3DA3 8B                    phb                            ; for addr of action routine
3147 3DA4
3148 3DA4 48                    pha                            ; save a
3149 3DA5 5A                    phy                            ; save y
3150 3DA6
3151 3DA6 A5 0A                 lda   PtrToThisOne+1           ;high byte and PCBank
3152 3DA8 83 06                 sta   s_AdrForAction+1,s       ;high byte and PCBank
3153 3DAA
3154 3DAA A9 0C 00              lda   #o_RunEntry              ; Code starts here
3155 3DAD 18                    clc   
3156 3DAE 65 09                 adc   PtrToThisOne
3157 3DB0 3A                    dec   a
3158 3DB1 83 05                 sta   s_AdrForAction,s         ;low and high byte return address
3159 3DB3
3160 3DB3 7A                    ply   
3161 3DB4 68                    pla   
3162 3DB5
3163 3DB5 6B                    rtl                            ;jump to RunEntry
3164 3DB6
3165 3DB6                       ENDP 
3166 3DB6
3167 3DB6
3168 3DB6              ****************************************************************
3169 3DB6              *
3170 3DB6              * RemoveNDA
3171 3DB6              *
3172 3DB6              *           HandleToNDA
3173 3DB6              *
3174 3DB6              * This is the routine we use to remove a new da in the system.
3175 3DB6              *
3176 3DB6              * This call removes an entry in the NDAList.  This
3177 3DB6              * entry contains most of the information in the NDA header.
3178 3DB6              *
3179 3DB6              * Change History
3180 3DB6              *
3181 3DB6              * 05 Oct 88             Added by Konstantin Othmer
3182 3DB6              *
3183 3DB6              ****************************************************************
3184 3DB6              RemoveNDA PROC EXPORT 
3185 3DB6
3186 3DB6                       import DerefNDAList 
3187 3DB6                       import UnlockNDAList 
3188 3DB6
3189 3DB6                       DSect OrigDirect+2 
3190 3DB6              Rtl1     block 3 
3191 3DB6              RTL2     block 3 
3192 3DB6              UserHandle long 
3193 3DB6
3194 3DB6 20 BF 3B              jsr   StartNDACall
3195 3DB9 20 37 3A              jsr   DerefNDAList             ;this locks the handle
3196 3DBC
3197 3DBC              ;First set up PtrToThisOne to first NDA in the list
3198 3DBC
3199 3DBC A9 0E 00              lda   #SizeofDeskGlobals
3200 3DBF 18                    clc   
3201 3DC0 65 01                 adc   NDAListPtr
3202 3DC2 85 09                 sta   PtrToThisOne
3203 3DC4 A5 03                 lda   NDAListPtr+2
3204 3DC6 69 00 00              adc   #0
3205 3DC9 85 0B                 sta   PtrToThisOne+2
3206 3DCB
3207 3DCB A7 01                 lda   [NDAListPtr]             ;number of entries
3208 3DCD 48                    pha   
3209 3DCE
3210 3DCE              ;Scan list to try to find UserHandle in the o_Handle field of the NDAList.
3211 3DCE
3212 3DCE 68           SearchLoop pla   
3213 3DCF F0 5A                 beq   NotFound
3214 3DD1 3A                    dec   a                        ;keep track of number left to search
3215 3DD2 48                    pha   
3216 3DD3
3217 3DD3 A0 1E 00              ldy   #o_Handle
3218 3DD6 A5 21                 lda   UserHandle
3219 3DD8 D7 09                 cmp   [PtrToThisOne],y
3220 3DDA D0 0A                 bne   Search1
3221 3DDC C8                    iny   
3222 3DDD C8                    iny   
3223 3DDE A5 23                 lda   UserHandle+2
3224 3DE0 D7 09                 cmp   [PtrToThisOne],y
3225 3DE2 D0 02                 bne   Search1
3226 3DE4 80 11                 bra   FoundIt
3227 3DE6
3228 3DE6              ;
3229 3DE6              ; Didn't find it yet.  Set up PtrtoThisOne for next NDA record and search again
3230 3DE6              ;
3231 3DE6 A5 09        Search1  lda   PtrToThisOne
3232 3DE8 18                    clc   
3233 3DE9 69 24 00              adc   #NDARecSize
3234 3DEC 85 09                 sta   PtrToThisOne
3235 3DEE A5 0B                 lda   PtrToThisOne+2
3236 3DF0 69 00 00              adc   #0
3237 3DF3 85 0B                 sta   PtrToThisOne+2
3238 3DF5 80 D7                 bra   SearchLoop
3239 3DF7
3240 3DF7              ;
3241 3DF7              ;found it.  Now we need to remove it.  All the remaining NDA's move up 20 bytes
3242 3DF7              ; Top word on stack contains the number of NDAs left in list (not including this one)
3243 3DF7              ;
3244 3DF7 A7 01        FoundIt  lda   [NDAListPtr]             ;number of NDAs:  decrement because
3245 3DF9 3A                    dec   a                        ;we remove one
3246 3DFA 87 01                 sta   [NDAListPtr]
3247 3DFC 80 0F                 bra   enter
3248 3DFE              MoveStart  
3249 3DFE A5 09                 lda   PtrToThisOne             ;Bump ptrtothisone so we can copy the next
3250 3E00 A6 0B                 ldx   PtrToThisOne+2           ;NDA to its proper place in the list.
3251 3E02 18                    clc   
3252 3E03 69 24 00              adc   #NDARecSize
3253 3E06 90 01                 bcc   @nocarry
3254 3E08 E8                    inx   
3255 3E09 85 09        @nocarry sta   PtrToThisOne
3256 3E0B 86 0B                 stx   PtrToThisOne+2
3257 3E0D
3258 3E0D 68           enter    pla                            ;number of NDA's left to search/move
3259 3E0E F0 20                 beq   SizeHandle               ;is this the last one?
3260 3E10 3A                    dec   a
3261 3E11 48                    pha                            ;This now is the number of NDA's we need to
3262 3E12                                                      ;move
3263 3E12              ;
3264 3E12              ;move record at PtrToThisOne+NDARecSize to PtrToThisOne
3265 3E12              ;
3266 3E12 A2 22 00              ldx   #NDARecSize-2            ;length of record to move
3267 3E15 A0 46 00              ldy   #NDARecSize*2-2          ;end of source
3268 3E18
3269 3E18 B7 09        MoveIt   lda   [PtrToThisOne],y
3270 3E1A 5A                    phy   
3271 3E1B DA                    phx   
3272 3E1C 7A                    ply                            ;transfer destination offset to y
3273 3E1D 97 09                 sta   [PtrToThisOne],y
3274 3E1F 7A                    ply                            ;get y back
3275 3E20 88                    dey   
3276 3E21 88                    dey   
3277 3E22 CA                    dex   
3278 3E23 CA                    dex                            ;update offsets
3279 3E24 E0 FE FF              cpx   #-2
3280 3E27 D0 EF                 bne   MoveIt
3281 3E29 80 D3                 bra   MoveStart
3282 3E2B              ;
3283 3E2B              ; this is inserted here so we can use a short branch to get to it
3284 3E2B A2 10 05     NotFound ldx   #daNotFound              ;Not found Error
3285 3E2E 80 31                 bra   GetOut
3286 3E30              ; end of insert
3287 3E30
3288 3E30              ;
3289 3E30              ; We've removed it.  Now free up extra room w/ memory manager
3290 3E30              ;
3291 3E30 48           SizeHandle pha                          ; space for result
3292 3E31 48                    pha   
3293 3E32 A7 01                 lda   [NDAListPtr]             ;new number of NDAs
3294 3E34 48                    pha                            ; New Number of entries 
3295 3E35 F4 24 00              PushWord #NDARecSize           ; Size of a NDArecord
3296 3E38 A2 0B 09 22           _Multiply 
3297 3E3F
3298 3E3F A3 01                 lda   1,s                      ; This is size of all NDA Records
3299 3E41 18                    clc                            ;now add in the header size (Deskglobals)
3300 3E42 69 0E 00              adc   #SizeOfDeskGlobals
3301 3E45
3302 3E45 83 01        SizeIsAdjusted sta   1,s
3303 3E47 A3 03                 lda   3,s
3304 3E49 69 00 00              adc   #0
3305 3E4C 83 03                 sta   3,s                      ;top of stack contains new handle size
3306 3E4E
3307 3E4E 20 55 3A              jsr   UnlockNDAList
3308 3E51
3309 3E51 D4 17                 pei   NDAListHandle+2
3310 3E53 D4 15                 pei   NDAListHandle
3311 3E55 A2 02 19 22           _SetHandleSize 
3312 3E5C B0 0A                 bcs   ERROR
3313 3E5E
3314 3E5E A2 00 00     AllDone  ldx   #0                       ;Successful removal
3315 3E61
3316 3E61 20 D3 3B     GetOut   jsr   EndNDACall
3317 3E64 5C 3E 1D 02           jml   oErrOut4
3318 3E68
3319 3E68 AA           Error    tax                            ;Handle Error
3320 3E69 80 F6                 bra   GetOut
3321 3E6B
3322 3E6B                       ENDP 
3323 3E6B
3324 3E6B
3325 3E6B              ****************************************************************
3326 3E6B              *
3327 3E6B              * $2305 GetDeskAccInfo
3328 3E6B              *
3329 3E6B              * New call for 6.0   11-Mar-91 DAL
3330 3E6B              *
3331 3E6B              * Inputs:
3332 3E6B              *    WORD  flags
3333 3E6B              *            bit 15: 0=call NDA, 1=call CDA
3334 3E6B              *            bits 14-1: reserved
3335 3E6B              *            bit  0: 0=daReference is index, 1=NDA window pointer
3336 3E6B              *    LONG  DA Reference (index number or window pointer)
3337 3E6B              *    WORD  buffer size in bytes
3338 3E6B              *    LONG  buffer pointer
3339 3E6B              *
3340 3E6B              * In the buffer, the first word returned is the number of bytes
3341 3E6B              * of valid data that follow.
3342 3E6B              *
3343 3E6B              ****************************************************************
3344 3E6B                       longa on                       ; mode
3345 3E6B                       longi on
3346 3E6B
3347 3E6B              GetDeskAccInfo PROC EXPORT
3348 3E6B
3349 3E6B 20 BF 3B              jsr   StartNDACall
3350 3E6E 20 37 3A              jsr   DerefNDAList
3351 3E71
3352 3E71              @buffer  equ   FirstInput
3353 3E71              @buffSize equ   @buffer+4
3354 3E71              @daReference equ   @buffSize+2
3355 3E71              @flags   equ   @daReference+4
3356 3E71
3357 3E71              @temp    equ   PtrToThisOne
3358 3E71
3359 3E71 A5 2B                 lda   <@flags
3360 3E73 30 60                 bmi   @CDAinfo
3361 3E75
3362 3E75 4A           @NDAinfo lsr   a                        ;bit 0: 1 for window pointer
3363 3E76 B0 34                 bcs   @byWindow
3364 3E78
3365 3E78 A5 27                 lda   <@daReference
3366 3E7A F0 2E                 beq   @invalid0
3367 3E7C 3A                    dec   a
3368 3E7D C7 01                 cmp   [<NDAListPtr]
3369 3E7F B0 29                 bcs   @invalid0
3370 3E81 48                    pha   
3371 3E82 48                    pha                            ;space for Multiply result
3372 3E83 48                    pha                            ;NDA number
3373 3E84 F4 24 00              pea   NDARecSize
3374 3E87 A2 0B 09 22           _Multiply 
3375 3E8E
3376 3E8E 18                    clc   
3377 3E8F A5 01                 lda   <NDAListPtr
3378 3E91 69 0E 00              adc   #SizeOfDeskGlobals
3379 3E94 85 09                 sta   <PtrToThisOne
3380 3E96 A5 03                 lda   <NDAListPtr+2
3381 3E98 69 00 00              adc   #0
3382 3E9B 85 0B                 sta   <PtrToThisOne+2
3383 3E9D
3384 3E9D 18                    clc   
3385 3E9E 68                    pla   
3386 3E9F 65 09                 adc   <PtrToThisOne
3387 3EA1 85 09                 sta   <PtrToThisOne
3388 3EA3 68                    pla   
3389 3EA4 65 0B                 adc   <PtrToThisOne+2
3390 3EA6 85 0B                 sta   <PtrToThisOne+2
3391 3EA8 80 0B                 bra   @copyInfo
3392 3EAA
3393 3EAA 80 77        @invalid0 bra   @invalid
3394 3EAC
3395 3EAC A6 29        @byWindow ldx   <@daReference+2
3396 3EAE A5 27                 lda   <@daReference
3397 3EB0 20 77 3A              jsr   FindThisWindow
3398 3EB3 90 6E                 bcc   @invalid
3399 3EB5
3400 3EB5 A5 25        @copyInfo lda   <@buffSize
3401 3EB7 C9 04 00              cmp   #4
3402 3EBA 90 67                 bcc   @invalid
3403 3EBC C9 24 00              cmp   #NDARecSize
3404 3EBF 90 03                 bcc   @thisMuch
3405 3EC1 A9 24 00              lda   #NDARecSize
3406 3EC4 87 21        @thisMuch sta   [<@buffer]
3407 3EC6 A8                    tay   
3408 3EC7 88           @copyStuff dey   
3409 3EC8 88                    dey   
3410 3EC9 B7 09                 lda   [<ptrToThisOne],y
3411 3ECB C8                    iny   
3412 3ECC C8                    iny   
3413 3ECD 97 21                 sta   [<@buffer],y
3414 3ECF 88                    dey   
3415 3ED0 88                    dey   
3416 3ED1 D0 F4                 bne   @copyStuff
3417 3ED3 80 44                 bra   @noProblem
3418 3ED5
3419 3ED5 A5 25        @CDAinfo lda   <@buffSize
3420 3ED7 C9 04 00              cmp   #4
3421 3EDA 90 42                 bcc   @buffTooSmall
3422 3EDC
3423 3EDC A5 27                 lda   <@daReference
3424 3EDE F0 43                 beq   @invalid
3425 3EE0 3A                    dec   a
3426 3EE1 CF 7C 1D E0           cmp   >NumDAs
3427 3EE5 B0 3C                 bcs   @invalid
3428 3EE7 0A                    asl   a
3429 3EE8 0A                    asl   a
3430 3EE9 48                    pha   
3431 3EEA
3432 3EEA AF 86 1D E0           lda   >CDATabHndl+2
3433 3EEE 85 0B                 sta   <@temp+2
3434 3EF0 AF 84 1D E0           lda   >CDATabHndl
3435 3EF4 85 09                 sta   <@temp
3436 3EF6 A0 02 00              ldy   #2
3437 3EF9 B7 09                 lda   [<@temp],y
3438 3EFB AA                    tax   
3439 3EFC A7 09                 lda   [<@temp]
3440 3EFE 85 09                 sta   <@temp
3441 3F00 86 0B                 stx   <@temp+2
3442 3F02 7A                    ply   
3443 3F03 B7 09                 lda   [<@temp],y
3444 3F05 AA                    tax   
3445 3F06 C8                    iny   
3446 3F07 C8                    iny   
3447 3F08 B7 09                 lda   [<@temp],y
3448 3F0A A0 04 00              ldy   #4
3449 3F0D 97 21                 sta   [<@buffer],y
3450 3F0F 88                    dey   
3451 3F10 88                    dey   
3452 3F11 8A                    txa   
3453 3F12 97 21                 sta   [<@buffer],y
3454 3F14 A9 04 00              lda   #4
3455 3F17 87 21                 sta   [<@buffer]
3456 3F19
3457 3F19 A2 00 00     @noProblem ldx   #0
3458 3F1C 80 08                 bra   @exit
3459 3F1E A2 4F 05     @buffTooSmall ldx   #$054F              ;dmBufferTooSmall
3460 3F21 80 03                 bra   @exit
3461 3F23 A2 20 05     @invalid ldx   #$0520                   ;bad input value
3462 3F26
3463 3F26 DA           @exit    phx   
3464 3F27 20 55 3A              jsr   UnlockNDAList
3465 3F2A FA                    plx   
3466 3F2B 20 D3 3B              jsr   EndNDACall
3467 3F2E A0 0C 00              ldy   #12
3468 3F31 5C 84 01 E1           jml   $e10184                  ;ToStrip
3469 3F35
3470 3F35                       EndP 
3471 3F35
3472 3F35
3473 3F35              ****************************************************************
3474 3F35              *
3475 3F35              * $2405 CallDeskAcc
3476 3F35              *
3477 3F35              * New call for 6.0   11-Mar-91 DAL
3478 3F35              *
3479 3F35              * Inputs:
3480 3F35              *   WORD  space for result
3481 3F35              *   WORD  flags
3482 3F35              *           bit 15: 0=call NDA, 1=call CDA
3483 3F35              *           bit 1: call the Init routine instead of Action (NDA)
3484 3F35              *           bit 0: 0=daReference is index, 1=window pointer
3485 3F35              *   LONG  daReference (index or window pointer)
3486 3F35              *   WORD  action code
3487 3F35              *   LONG  data to pass to NDA
3488 3F35              *
3489 3F35              ****************************************************************
3490 3F35                       longa on                       ; mode
3491 3F35                       longi on
3492 3F35
3493 3F35              CallDeskAcc PROC EXPORT
3494 3F35
3495 3F35 20 BF 3B              jsr   StartNDACall
3496 3F38 20 37 3A              jsr   DerefNDAList
3497 3F3B
3498 3F3B              @data    equ   FirstInput
3499 3F3B              @action  equ   @data+4
3500 3F3B              @daReference equ   @action+2
3501 3F3B              @flags   equ   @daReference+4
3502 3F3B              @result  equ   @flags+2
3503 3F3B
3504 3F3B              @temp    equ   PtrToThisOne
3505 3F3B
3506 3F3B 64 2D                 stz   <@result
3507 3F3D
3508 3F3D A5 2B                 lda   <@flags
3509 3F3F 10 03                 bpl   @callNDA
3510 3F41 82 98 00              brl   @callCDA
3511 3F44
3512 3F44 4A           @callNDA lsr   a                        ;bit 0: 1 for window pointer
3513 3F45 B0 35                 bcs   @byWindow
3514 3F47
3515 3F47 A5 27                 lda   <@daReference
3516 3F49 F0 05                 beq   @invalid0
3517 3F4B 3A                    dec   a
3518 3F4C C7 01                 cmp   [<NDAListPtr]
3519 3F4E 90 03                 bcc   @ok
3520 3F50 82 90 00     @invalid0 brl   @invalid
3521 3F53
3522 3F53 48           @ok      pha   
3523 3F54 48                    pha                            ;space for Multiply result
3524 3F55 48                    pha                            ;NDA number
3525 3F56 F4 24 00              pea   NDARecSize
3526 3F59 A2 0B 09 22           _Multiply 
3527 3F60
3528 3F60 18                    clc   
3529 3F61 A5 01                 lda   <NDAListPtr
3530 3F63 69 0E 00              adc   #SizeOfDeskGlobals
3531 3F66 85 09                 sta   <PtrToThisOne
3532 3F68 A5 03                 lda   <NDAListPtr+2
3533 3F6A 69 00 00              adc   #0
3534 3F6D 85 0B                 sta   <PtrToThisOne+2
3535 3F6F
3536 3F6F 18                    clc   
3537 3F70 68                    pla   
3538 3F71 65 09                 adc   <PtrToThisOne
3539 3F73 85 09                 sta   <PtrToThisOne
3540 3F75 68                    pla   
3541 3F76 65 0B                 adc   <PtrToThisOne+2
3542 3F78 85 0B                 sta   <PtrToThisOne+2
3543 3F7A 80 09                 bra   @callTheNDA
3544 3F7C
3545 3F7C A6 29        @byWindow ldx   <@daReference+2
3546 3F7E A5 27                 lda   <@daReference
3547 3F80 20 77 3A              jsr   FindThisWindow
3548 3F83 90 5E                 bcc   @invalid
3549 3F85
3550 3F85 A5 2B        @callTheNDA lda   <@flags
3551 3F87 29 02 00              and   #2
3552 3F8A D0 28                 bne   @callNDAInit
3553 3F8C
3554 3F8C A0 14 00              ldy   #o_EventMask
3555 3F8F B7 09                 lda   [<PtrToThisOne],y
3556 3F91 29 00 F0              and   #$f000
3557 3F94 C9 00 A0              cmp   #$a000
3558 3F97 F0 07                 beq   @eatsAnything
3559 3F99 A5 25                 lda   <@action
3560 3F9B C9 0A 00              cmp   #10
3561 3F9E B0 43                 bcs   @invalid
3562 3FA0
3563 3FA0 20 21 3B     @eatsAnything jsr   SetResID
3564 3FA3 A5 25                 lda   <@action
3565 3FA5 A4 23                 ldy   <@data+2
3566 3FA7 A6 21                 ldx   <@data
3567 3FA9 22 90 3B 02           jsl   SendAction               ;A=action, YX=data
3568 3FAD 85 2D                 sta   <@result
3569 3FAF 20 4C 3B              jsr   RepResID
3570 3FB2 80 2A                 bra   @noProblem
3571 3FB4
3572 3FB4 A0 14 00     @callNDAInit ldy   #o_EventMask
3573 3FB7 B7 09                 lda   [<PtrToThisOne],y
3574 3FB9 29 00 F0              and   #$f000
3575 3FBC C9 00 A0              cmp   #$a000
3576 3FBF F0 07                 beq   @eatAnything2
3577 3FC1 A5 25                 lda   <@action
3578 3FC3 C9 02 00              cmp   #2
3579 3FC6 B0 1B                 bcs   @invalid
3580 3FC8
3581 3FC8 20 21 3B     @eatAnything2 jsr   SetResID
3582 3FCB A5 25                 lda   <@action
3583 3FCD A4 23                 ldy   <@data+2
3584 3FCF A6 21                 ldx   <@data
3585 3FD1 22 87 3B 02           jsl   SendInit
3586 3FD5 85 2D                 sta   <@result
3587 3FD7 20 4C 3B              jsr   RepResID
3588 3FDA 80 02                 bra   @noProblem
3589 3FDC
3590 3FDC              @callCDA  
3591 3FDC 80 05                 bra   @invalid
3592 3FDE
3593 3FDE
3594 3FDE A2 00 00     @noProblem ldx   #0
3595 3FE1 80 03                 bra   @exit
3596 3FE3 A2 20 05     @invalid ldx   #$0520                   ;bad input value
3597 3FE6 DA           @exit    phx   
3598 3FE7 20 55 3A              jsr   UnlockNDAList
3599 3FEA FA                    plx   
3600 3FEB 20 D3 3B              jsr   EndNDACall
3601 3FEE A0 0C 00              ldy   #12
3602 3FF1 5C 84 01 E1           jml   $e10184                  ;ToStrip
3603 3FF5
3604 3FF5                       EndP 
3605 3FF5
3606 3FF5
3607 3FF5              ****************************************************************
3608 3FF5              *
3609 3FF5              * $2505 GetDeskGlobal
3610 3FF5              *
3611 3FF5              * Inputs:
3612 3FF5              *    LONG space for result
3613 3FF5              *    WORD selector
3614 3FF5              *
3615 3FF5              * Selector values:
3616 3FF5              *    0 = return the current window pointer (to be used
3617 3FF5              *        when an Action proc gets called, in case the
3618 3FF5              *        same action proc is shared among multiple windows)
3619 3FF5              *
3620 3FF5              * New call for 6.0   19-Feb-91 DAL
3621 3FF5              *
3622 3FF5              ****************************************************************
3623 3FF5              GetDeskGlobal proc export
3624 3FF5                       import DeskGlobalWindow 
3625 3FF5
3626 3FF5              selector equ   7                        ;stack
3627 3FF5              result   equ   selector+2
3628 3FF5
3629 3FF5 A2 20 05              ldx   #$0520                   ;bad input value
3630 3FF8 A3 07                 lda   selector,s
3631 3FFA D0 0F                 bne   @error
3632 3FFC
3633 3FFC AF 0F 3B 02           lda   >DeskGlobalWindow
3634 4000 83 09                 sta   result,s
3635 4002 AF 11 3B 02           lda   >DeskGlobalWindow+2
3636 4006 83 0B                 sta   result+2,s
3637 4008 A2 00 00              ldx   #0
3638 400B A0 02 00     @error   ldy   #2                       ;strip 2 bytes
3639 400E 5C 84 01 E1           jml   >$e10184                 ;ToStrip
3640 4012
3641 4012
3642 4012                       END   
